/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.io.IOException;
import java.util.Collection;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentIndexedStorageAction;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentStorageActionTest;
import net.shibboleth.idp.consent.storage.impl.CollectionSerializer;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.storage.StorageRecord;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractConsentIndexedStorageActionTest
extends AbstractConsentStorageActionTest {
    @Override
    protected void populateAction() throws Exception {
        super.populateAction();
        ((AbstractConsentIndexedStorageAction)this.action).setStorageIndexKeyLookupStrategy(FunctionSupport.constant((Object)"_index"));
    }

    protected Collection<String> readStorageKeysFromIndex() throws IOException {
        StorageRecord index = this.getMemoryStorageService().read("context", "_index");
        Assert.assertNotNull((Object)index);
        CollectionSerializer collectionSerializer = (CollectionSerializer)((AbstractConsentIndexedStorageAction)this.action).getStorageKeysSerializer();
        Assert.assertNotNull((Object)collectionSerializer);
        return collectionSerializer.deserialize(0L, "context", "_index", index.getValue(), index.getExpiration());
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableStorageIndexKeyStrategy() throws Exception {
        this.action.initialize();
        ((AbstractConsentIndexedStorageAction)this.action).setStorageIndexKeyLookupStrategy(null);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableStorageKeysSerializerStrategy() throws Exception {
        this.action.initialize();
        ((AbstractConsentIndexedStorageAction)this.action).setStorageKeysSerializer(null);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableStorageKeysStrategy() throws Exception {
        this.action.initialize();
        ((AbstractConsentIndexedStorageAction)this.action).setStorageKeysStrategy(null);
    }
}

