/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentIndexedStorageActionTest;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentStorageAction;
import net.shibboleth.idp.consent.flow.storage.impl.CreateResult;
import net.shibboleth.idp.consent.impl.ConsentTestingSupport;
import net.shibboleth.idp.consent.storage.impl.ConsentSerializer;
import net.shibboleth.idp.profile.ActionTestingSupport;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CreateResultTest
extends AbstractConsentIndexedStorageActionTest {
    protected CreateResult buildAction(@Nonnull String key) throws Exception {
        CreateResult action1 = new CreateResult();
        action1.setStorageContextLookupStrategy(FunctionSupport.constant((Object)"context"));
        action1.setStorageKeyLookupStrategy(FunctionSupport.constant((Object)key));
        action1.setStorageIndexKeyLookupStrategy(FunctionSupport.constant((Object)"_index"));
        action1.initialize();
        return action1;
    }

    protected Map<String, Consent> readConsentFromStorage(@Nonnull String key) throws Exception {
        StorageRecord record = this.getMemoryStorageService().read("context", key);
        Assert.assertNotNull((Object)record);
        ConsentSerializer serializer = new ConsentSerializer();
        return serializer.deserialize(0L, "context", key, record.getValue(), record.getExpiration());
    }

    @BeforeMethod
    public void setUpAction() throws Exception {
        this.action = new CreateResult();
        this.populateAction();
    }

    @Test
    public void testNoCurrentConsents() throws Exception {
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        ProfileInterceptorContext pic = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class, false);
        Assert.assertNotNull((Object)pic);
        Assert.assertEquals((int)pic.getResults().size(), (int)0);
        StorageRecord record = this.getMemoryStorageService().read("context", "key");
        Assert.assertNull((Object)record);
    }

    @Test
    public void testCreateResult() throws Exception {
        this.action.initialize();
        ConsentContext consentCtx = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        consentCtx.getCurrentConsents().putAll(ConsentTestingSupport.newConsentMap());
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        ProfileInterceptorContext pic = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class, false);
        Assert.assertNotNull((Object)pic);
        Assert.assertEquals((int)pic.getResults().size(), (int)0);
        Map<String, Consent> consents = this.readConsentsFromStorage();
        Assert.assertEquals((int)consents.size(), (int)2);
        Assert.assertEquals(consents, ConsentTestingSupport.newConsentMap());
        Collection<String> keys = this.readStorageKeysFromIndex();
        Assert.assertEquals(keys, Arrays.asList("key"));
    }

    @Test
    public void testCreateResultWithSymbolics() throws Exception {
        ConsentSerializer serializer = new ConsentSerializer();
        serializer.setSymbolics(ConsentTestingSupport.newSymbolicsMap());
        serializer.initialize();
        ((AbstractConsentStorageAction)this.action).setStorageSerializer((StorageSerializer)serializer);
        this.testCreateResult();
        StorageRecord record = this.getMemoryStorageService().read("context", "key");
        Assert.assertEquals((String)record.getValue(), (String)"[{\"id\":101,\"v\":\"value1\",\"appr\":false},{\"id\":102,\"v\":\"value2\",\"appr\":false}]");
    }

    @Test
    public void testUpdateResult() throws Exception {
        this.action.initialize();
        ConsentContext consentCtx = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        consentCtx.getCurrentConsents().putAll(ConsentTestingSupport.newConsentMap());
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.src));
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.src));
        ProfileInterceptorContext pic = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class, false);
        Assert.assertNotNull((Object)pic);
        Assert.assertEquals((int)pic.getResults().size(), (int)0);
        Map<String, Consent> consents = this.readConsentsFromStorage();
        Assert.assertEquals((int)consents.size(), (int)2);
        Assert.assertEquals(consents, ConsentTestingSupport.newConsentMap());
        Collection<String> keys = this.readStorageKeysFromIndex();
        Assert.assertEquals(keys, Arrays.asList("key"));
    }

    @Test
    public void testUpdateResultWithSymbolics() throws Exception {
        ConsentSerializer serializer = new ConsentSerializer();
        serializer.setSymbolics(ConsentTestingSupport.newSymbolicsMap());
        serializer.initialize();
        ((AbstractConsentStorageAction)this.action).setStorageSerializer((StorageSerializer)serializer);
        this.testUpdateResult();
        StorageRecord record = this.getMemoryStorageService().read("context", "key");
        Assert.assertEquals((String)record.getValue(), (String)"[{\"id\":101,\"v\":\"value1\",\"appr\":false},{\"id\":102,\"v\":\"value2\",\"appr\":false}]");
    }

    @Test
    public void testMaxStoredRecords() throws Exception {
        this.descriptor.setExpandedNumberOfStoredRecords(2);
        this.descriptor.setMaximumNumberOfStoredRecords(2);
        ConsentContext consentCtx = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        consentCtx.getCurrentConsents().putAll(ConsentTestingSupport.newConsentMap());
        CreateResult action1 = this.buildAction("key1");
        ActionTestingSupport.assertProceedEvent((Event)action1.execute(this.src));
        Map<String, Consent> consents1 = this.readConsentFromStorage("key1");
        Assert.assertEquals((int)consents1.size(), (int)2);
        Assert.assertEquals(consents1, ConsentTestingSupport.newConsentMap());
        Assert.assertEquals(this.readStorageKeysFromIndex(), Arrays.asList("key1"));
        CreateResult action2 = this.buildAction("key2");
        ActionTestingSupport.assertProceedEvent((Event)action2.execute(this.src));
        Map<String, Consent> consents2 = this.readConsentFromStorage("key2");
        Assert.assertEquals((int)consents2.size(), (int)2);
        Assert.assertEquals(consents2, ConsentTestingSupport.newConsentMap());
        Assert.assertEquals(this.readStorageKeysFromIndex(), Arrays.asList("key1", "key2"));
        CreateResult action3 = this.buildAction("key3");
        ActionTestingSupport.assertProceedEvent((Event)action3.execute(this.src));
        Map<String, Consent> consents3 = this.readConsentFromStorage("key3");
        Assert.assertEquals((int)consents3.size(), (int)2);
        Assert.assertEquals(consents3, ConsentTestingSupport.newConsentMap());
        Assert.assertEquals(this.readStorageKeysFromIndex(), Arrays.asList("key2", "key3"));
    }

    @Test
    public void testNoMaxStoredRecords() throws Exception {
        this.descriptor.setMaximumNumberOfStoredRecords(0);
        this.descriptor.setExpandedNumberOfStoredRecords(0);
        ConsentContext consentCtx = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        consentCtx.getCurrentConsents().putAll(ConsentTestingSupport.newConsentMap());
        ArrayList<CallSite> keys = new ArrayList<CallSite>();
        for (int i = 1; i <= 10; ++i) {
            ActionTestingSupport.assertProceedEvent((Event)this.buildAction("key" + Integer.toString(i)).execute(this.src));
            keys.add((CallSite)((Object)("key" + Integer.toString(i))));
        }
        Assert.assertEquals(this.readStorageKeysFromIndex(), keys);
    }
}

