/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.Arrays;
import java.util.regex.Pattern;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.consent.logic.impl.AttributePredicate;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributePredicateTest {
    private AttributePredicate p;
    private IdPAttribute attribute1;
    private IdPAttribute attribute2;

    @BeforeMethod
    public void setUp() {
        this.attribute1 = new IdPAttribute("attribute1");
        this.attribute1.setValues(Arrays.asList(new StringAttributeValue("value1")));
        this.attribute2 = new IdPAttribute("attribute2");
        this.attribute2.setValues(Arrays.asList(new StringAttributeValue("value2"), new StringAttributeValue("value3")));
        this.p = new AttributePredicate();
    }

    @Test
    public void testWhitelist() {
        this.p.setWhitelistedAttributeIds(Arrays.asList("attribute1"));
        Assert.assertTrue((boolean)this.p.test(this.attribute1));
        Assert.assertFalse((boolean)this.p.test(this.attribute2));
    }

    @Test
    public void testBlacklist() {
        this.p.setBlacklistedAttributeIds(Arrays.asList("attribute1"));
        Assert.assertFalse((boolean)this.p.test(this.attribute1));
        Assert.assertTrue((boolean)this.p.test(this.attribute2));
    }

    @Test
    public void testMatchExpression() {
        this.p.setAttributeIdMatchExpression(Pattern.compile(".*1"));
        Assert.assertTrue((boolean)this.p.test(this.attribute1));
        Assert.assertFalse((boolean)this.p.test(this.attribute2));
    }

    @Test
    public void testWhitelistAndBlacklist() {
        this.p.setWhitelistedAttributeIds(Arrays.asList("attribute1"));
        this.p.setBlacklistedAttributeIds(Arrays.asList("attribute1"));
        Assert.assertFalse((boolean)this.p.test(this.attribute1));
        Assert.assertFalse((boolean)this.p.test(this.attribute2));
        this.p.setBlacklistedAttributeIds(Arrays.asList("attribute2"));
        Assert.assertTrue((boolean)this.p.test(this.attribute1));
        Assert.assertFalse((boolean)this.p.test(this.attribute2));
    }

    @Test
    public void testWhitelistAndMatchExpression() {
        this.p.setWhitelistedAttributeIds(Arrays.asList("attribute1"));
        this.p.setAttributeIdMatchExpression(Pattern.compile(".*1"));
        Assert.assertTrue((boolean)this.p.test(this.attribute1));
        Assert.assertFalse((boolean)this.p.test(this.attribute2));
        this.p.setAttributeIdMatchExpression(Pattern.compile(".*2"));
        Assert.assertFalse((boolean)this.p.test(this.attribute1));
        Assert.assertTrue((boolean)this.p.test(this.attribute2));
    }

    @Test
    public void testBlacklistAndMatchExpression() {
        this.p.setBlacklistedAttributeIds(Arrays.asList("attribute1"));
        this.p.setAttributeIdMatchExpression(Pattern.compile(".*1"));
        Assert.assertFalse((boolean)this.p.test(this.attribute1));
        Assert.assertFalse((boolean)this.p.test(this.attribute2));
        this.p.setAttributeIdMatchExpression(Pattern.compile(".*2"));
        Assert.assertFalse((boolean)this.p.test(this.attribute1));
        Assert.assertTrue((boolean)this.p.test(this.attribute2));
    }

    @Test
    public void testWhitelistAndBlacklistAndMatchExpression() {
        this.p.setWhitelistedAttributeIds(Arrays.asList("attribute1"));
        this.p.setBlacklistedAttributeIds(Arrays.asList("attribute1"));
        this.p.setAttributeIdMatchExpression(Pattern.compile(".*1"));
        Assert.assertFalse((boolean)this.p.test(this.attribute1));
        Assert.assertFalse((boolean)this.p.test(this.attribute2));
        this.p.setWhitelistedAttributeIds(Arrays.asList("attribute1"));
        this.p.setBlacklistedAttributeIds(Arrays.asList("attribute2"));
        this.p.setAttributeIdMatchExpression(Pattern.compile(".*1"));
        Assert.assertTrue((boolean)this.p.test(this.attribute1));
        Assert.assertFalse((boolean)this.p.test(this.attribute2));
        this.p.setWhitelistedAttributeIds(Arrays.asList("attribute1"));
        this.p.setBlacklistedAttributeIds(Arrays.asList("attribute1"));
        this.p.setAttributeIdMatchExpression(Pattern.compile(".*2"));
        Assert.assertFalse((boolean)this.p.test(this.attribute1));
        Assert.assertTrue((boolean)this.p.test(this.attribute2));
        this.p.setWhitelistedAttributeIds(Arrays.asList("attribute1"));
        this.p.setBlacklistedAttributeIds(Arrays.asList("attribute2"));
        this.p.setAttributeIdMatchExpression(Pattern.compile(".*2"));
        Assert.assertFalse((boolean)this.p.test(this.attribute1));
        Assert.assertTrue((boolean)this.p.test(this.attribute2));
    }

    @Test
    public void testNullInput() {
        this.p = new AttributePredicate();
        Assert.assertFalse((boolean)this.p.test(null));
    }

    @Test
    public void testEmptyAttribute() {
        IdPAttribute emptyAttribute = new IdPAttribute("emptyAttribute");
        Assert.assertFalse((boolean)this.p.test(emptyAttribute));
        emptyAttribute.setValues(Arrays.asList(StringAttributeValue.valueOf((String)""), StringAttributeValue.valueOf(null)));
        Assert.assertFalse((boolean)this.p.test(emptyAttribute));
        emptyAttribute.setValues(Arrays.asList(StringAttributeValue.valueOf((String)"1"), StringAttributeValue.valueOf((String)"")));
        Assert.assertTrue((boolean)this.p.test(emptyAttribute));
    }
}

