/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.AttributeReleaseContext;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.idp.consent.impl.ConsentTestingSupport;
import net.shibboleth.idp.consent.logic.impl.AttributeReleaseConsentFunction;
import net.shibboleth.idp.consent.logic.impl.AttributeValuesHashFunction;
import net.shibboleth.idp.profile.RequestContextBuilder;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeReleaseConsentFunctionTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private AttributeValuesHashFunction attributeValuesHashFunction;
    private AttributeReleaseConsentFunction function;

    @BeforeMethod
    public void setUp() throws Exception {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.attributeValuesHashFunction = new AttributeValuesHashFunction();
        this.function = new AttributeReleaseConsentFunction();
    }

    private void setUpDescriptor(boolean compareValues) {
        ConsentFlowDescriptor descriptor = new ConsentFlowDescriptor();
        descriptor.setId("test");
        descriptor.setCompareValues(compareValues);
        ProfileInterceptorContext pic = new ProfileInterceptorContext();
        pic.setAttemptedFlow((ProfileInterceptorFlowDescriptor)descriptor);
        this.prc.addSubcontext((BaseContext)pic);
        Assert.assertNotNull((Object)this.prc.getSubcontext(ProfileInterceptorContext.class));
        Assert.assertNotNull((Object)((ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class)).getAttemptedFlow());
        Assert.assertTrue((boolean)(((ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class)).getAttemptedFlow() instanceof ConsentFlowDescriptor));
        Assert.assertEquals((boolean)((ConsentFlowDescriptor)((ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class)).getAttemptedFlow()).compareValues(), (boolean)compareValues);
    }

    @Test
    public void testNullInput() {
        Assert.assertNull((Object)this.function.apply(null));
    }

    @Test
    public void testNullConsentContext() {
        Assert.assertNull((Object)this.prc.getSubcontext(ConsentContext.class));
        this.setUpDescriptor(false);
        Assert.assertNull((Object)this.function.apply(this.prc));
    }

    @Test
    public void testNullConsentFlowDescriptor() {
        this.prc.addSubcontext((BaseContext)new ConsentContext());
        this.prc.addSubcontext((BaseContext)new ProfileInterceptorContext());
        Assert.assertNull((Object)((ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class)).getAttemptedFlow());
        Assert.assertNull((Object)this.function.apply(this.prc));
    }

    @Test
    public void testNullAttributeReleaseContext() {
        this.prc.addSubcontext((BaseContext)new ConsentContext());
        this.setUpDescriptor(false);
        Assert.assertNull((Object)this.prc.getSubcontext(AttributeReleaseContext.class));
        Assert.assertNull((Object)this.function.apply(this.prc));
    }

    @Test
    public void testNoConsentableAttributes() {
        this.prc.addSubcontext((BaseContext)new ConsentContext());
        this.prc.addSubcontext((BaseContext)new AttributeReleaseContext(), true);
        this.setUpDescriptor(false);
        Assert.assertTrue((boolean)((AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class)).getConsentableAttributes().isEmpty());
        Assert.assertTrue((boolean)this.function.apply(this.prc).isEmpty());
    }

    @Test
    public void testNoPreviousConsents() {
        this.prc.addSubcontext((BaseContext)new ConsentContext());
        AttributeReleaseContext arc = new AttributeReleaseContext();
        arc.getConsentableAttributes().putAll(ConsentTestingSupport.newAttributeMap());
        this.prc.addSubcontext((BaseContext)arc);
        this.setUpDescriptor(false);
        Assert.assertFalse((boolean)((AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class)).getConsentableAttributes().isEmpty());
        Assert.assertTrue((boolean)((ConsentContext)this.prc.getSubcontext(ConsentContext.class)).getPreviousConsents().isEmpty());
        HashMap<String, Consent> expected = new HashMap<String, Consent>();
        for (IdPAttribute attr : ConsentTestingSupport.newAttributeMap().values()) {
            Consent consent = new Consent();
            consent.setId(attr.getId());
            expected.put(consent.getId(), consent);
        }
        Assert.assertEquals((Map)this.function.apply(this.prc), expected);
    }

    @Test
    public void testNoPreviousConsentsCompareValues() {
        this.prc.addSubcontext((BaseContext)new ConsentContext());
        AttributeReleaseContext arc = new AttributeReleaseContext();
        arc.getConsentableAttributes().putAll(ConsentTestingSupport.newAttributeMap());
        this.prc.addSubcontext((BaseContext)arc);
        this.setUpDescriptor(true);
        Assert.assertFalse((boolean)((AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class)).getConsentableAttributes().isEmpty());
        Assert.assertTrue((boolean)((ConsentContext)this.prc.getSubcontext(ConsentContext.class)).getPreviousConsents().isEmpty());
        HashMap<String, Consent> expected = new HashMap<String, Consent>();
        for (IdPAttribute attr : ConsentTestingSupport.newAttributeMap().values()) {
            Consent consent = new Consent();
            consent.setId(attr.getId());
            consent.setValue(this.attributeValuesHashFunction.apply((Collection)attr.getValues()));
            expected.put(consent.getId(), consent);
        }
        Assert.assertEquals((Map)this.function.apply(this.prc), expected);
    }

    @Test
    public void testRememberPreviousConsents() {
        Consent previousConsent = new Consent();
        previousConsent.setId("attribute1");
        previousConsent.setApproved(true);
        ConsentContext consentCtx = new ConsentContext();
        consentCtx.getPreviousConsents().put(previousConsent.getId(), previousConsent);
        this.prc.addSubcontext((BaseContext)consentCtx);
        AttributeReleaseContext arc = new AttributeReleaseContext();
        arc.getConsentableAttributes().putAll(ConsentTestingSupport.newAttributeMap());
        this.prc.addSubcontext((BaseContext)arc);
        this.setUpDescriptor(false);
        Assert.assertFalse((boolean)((AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class)).getConsentableAttributes().isEmpty());
        Assert.assertFalse((boolean)((ConsentContext)this.prc.getSubcontext(ConsentContext.class)).getPreviousConsents().isEmpty());
        HashMap<String, Consent> expected = new HashMap<String, Consent>();
        for (IdPAttribute attr : ConsentTestingSupport.newAttributeMap().values()) {
            Consent consent = new Consent();
            consent.setId(attr.getId());
            if (attr.getId().equals("attribute1")) {
                consent.setApproved(true);
            }
            expected.put(consent.getId(), consent);
        }
        Assert.assertEquals((Map)this.function.apply(this.prc), expected);
    }

    @Test
    public void testRememberPreviousConsentsCompareValues() {
        Consent previousConsent = new Consent();
        previousConsent.setId("attribute1");
        previousConsent.setValue(this.attributeValuesHashFunction.apply((Collection)ConsentTestingSupport.newAttributeMap().get("attribute1").getValues()));
        previousConsent.setApproved(true);
        ConsentContext consentCtx = new ConsentContext();
        consentCtx.getPreviousConsents().put(previousConsent.getId(), previousConsent);
        this.prc.addSubcontext((BaseContext)consentCtx);
        AttributeReleaseContext arc = new AttributeReleaseContext();
        arc.getConsentableAttributes().putAll(ConsentTestingSupport.newAttributeMap());
        this.prc.addSubcontext((BaseContext)arc);
        this.setUpDescriptor(true);
        Assert.assertFalse((boolean)((AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class)).getConsentableAttributes().isEmpty());
        Assert.assertFalse((boolean)((ConsentContext)this.prc.getSubcontext(ConsentContext.class)).getPreviousConsents().isEmpty());
        HashMap<String, Consent> expected = new HashMap<String, Consent>();
        for (IdPAttribute attr : ConsentTestingSupport.newAttributeMap().values()) {
            Consent consent = new Consent();
            consent.setId(attr.getId());
            consent.setValue(this.attributeValuesHashFunction.apply((Collection)attr.getValues()));
            if (attr.getId().equals("attribute1")) {
                consent.setApproved(true);
            }
            expected.put(consent.getId(), consent);
        }
        Assert.assertEquals((Map)this.function.apply(this.prc), expected);
    }

    @Test
    public void testRememberPreviousConsentsDifferentValueCompareValues() {
        Consent previousConsent = new Consent();
        previousConsent.setId("attribute1");
        previousConsent.setValue("differentValue");
        previousConsent.setApproved(true);
        ConsentContext consentCtx = new ConsentContext();
        consentCtx.getPreviousConsents().put(previousConsent.getId(), previousConsent);
        this.prc.addSubcontext((BaseContext)consentCtx);
        AttributeReleaseContext arc = new AttributeReleaseContext();
        arc.getConsentableAttributes().putAll(ConsentTestingSupport.newAttributeMap());
        this.prc.addSubcontext((BaseContext)arc);
        this.setUpDescriptor(true);
        Assert.assertFalse((boolean)((AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class)).getConsentableAttributes().isEmpty());
        Assert.assertFalse((boolean)((ConsentContext)this.prc.getSubcontext(ConsentContext.class)).getPreviousConsents().isEmpty());
        HashMap<String, Consent> expected = new HashMap<String, Consent>();
        for (IdPAttribute attr : ConsentTestingSupport.newAttributeMap().values()) {
            Consent consent = new Consent();
            consent.setId(attr.getId());
            consent.setValue(this.attributeValuesHashFunction.apply((Collection)attr.getValues()));
            expected.put(consent.getId(), consent);
        }
        Assert.assertEquals((Map)this.function.apply(this.prc), expected);
    }
}

