/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.impl;

import java.time.Duration;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class ConsentFlowDescriptor
extends ProfileInterceptorFlowDescriptor {
    private boolean compareValues;
    @Nonnull
    private Duration lifetime = Duration.ofDays(365L);
    private int maxStoredRecords;
    private int expandedMaxStoredRecords;
    private long expandedStorageThreshold = 0x100000L;

    public boolean compareValues() {
        return this.compareValues;
    }

    @Nonnull
    public Duration getLifetime() {
        return this.lifetime;
    }

    public int getMaximumNumberOfStoredRecords() {
        return this.maxStoredRecords;
    }

    public int getExpandedNumberOfStoredRecords() {
        return this.expandedMaxStoredRecords;
    }

    public long getExpandedStorageThreshold() {
        return this.expandedStorageThreshold;
    }

    public void setCompareValues(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.compareValues = flag;
    }

    public void setLifetime(@Nonnull Duration consentLifetime) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.lifetime = (Duration)Constraint.isNotNull((Object)consentLifetime, (String)"Lifetime cannot be null");
    }

    public void setMaximumNumberOfStoredRecords(int maximum) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.maxStoredRecords = maximum;
    }

    public void setExpandedNumberOfStoredRecords(int maximum) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.expandedMaxStoredRecords = maximum;
    }

    public void setExpandedStorageThreshold(long size) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.expandedStorageThreshold = size;
    }
}

