/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.impl;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.flow.impl.AbstractConsentAction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateConsentContext
extends AbstractConsentAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateConsentContext.class);
    @Nonnull
    private Function<ProfileRequestContext, Map<String, Consent>> function;

    public PopulateConsentContext(@Nonnull Function<ProfileRequestContext, Map<String, Consent>> currentConsentsFunction) {
        this.function = (Function)Constraint.isNotNull(currentConsentsFunction, (String)"Current consents function cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        Map<String, Consent> consents = this.function.apply(profileRequestContext);
        this.log.debug("{} Populating consents: {}", (Object)this.getLogPrefix(), consents.keySet());
        if (consents != null) {
            this.getConsentContext().getCurrentConsents().putAll(consents);
        }
    }
}

