/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public abstract class AbstractAttributeDisplayFunction
implements Function<IdPAttribute, String> {
    @Nonnull
    @Unmodifiable
    private final List<Locale.LanguageRange> languageRange;
    @Nonnull
    @Unmodifiable
    private final List<Locale.LanguageRange> defaultLanguageRange;

    public AbstractAttributeDisplayFunction(@Nonnull HttpServletRequest request, @Nullable List<String> defaultLanguages) {
        this.languageRange = HttpServletSupport.getLanguageRange((HttpServletRequest)request);
        this.defaultLanguageRange = defaultLanguages == null || defaultLanguages.isEmpty() ? Collections.emptyList() : defaultLanguages.stream().map(StringSupport::trimOrNull).filter(e -> e != null).map(s -> new Locale.LanguageRange((String)s)).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @Nullable
    public String apply(@Nullable IdPAttribute input) {
        if (input == null) {
            return "N/A";
        }
        Map<Locale, String> displayInfo = this.getDisplayInfo(input);
        Locale locale = Locale.lookup(this.languageRange, displayInfo.keySet());
        if (locale == null) {
            locale = Locale.lookup(this.defaultLanguageRange, displayInfo.keySet());
        }
        if (locale == null) {
            return input.getId();
        }
        return displayInfo.get(locale);
    }

    @Nonnull
    protected abstract Map<Locale, String> getDisplayInfo(@Nonnull IdPAttribute var1);
}

