/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.impl;

import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.idp.consent.flow.impl.AbstractConsentActionTest;
import net.shibboleth.idp.consent.flow.impl.ExtractConsent;
import net.shibboleth.idp.consent.impl.ConsentTestingSupport;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExtractConsentTest
extends AbstractConsentActionTest {
    @BeforeMethod
    public void setUpCurrentConsents() throws Exception {
        ConsentContext consentContext = (ConsentContext)this.prc.getSubcontext(ConsentContext.class, false);
        consentContext.getCurrentConsents().putAll(ConsentTestingSupport.newConsentMap());
    }

    @Test
    public void testMissingHttpServletRequest() throws Exception {
        this.action = new ExtractConsent();
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
        ConsentContext consentContext = (ConsentContext)this.prc.getSubcontext(ConsentContext.class, false);
        Assert.assertNotNull((Object)consentContext);
        Consent consent1 = (Consent)consentContext.getCurrentConsents().get("consent1");
        Consent consent2 = (Consent)consentContext.getCurrentConsents().get("consent2");
        Assert.assertNotNull((Object)consent1);
        Assert.assertNotNull((Object)consent2);
        Assert.assertFalse((boolean)consent1.isApproved());
        Assert.assertFalse((boolean)consent2.isApproved());
    }

    @Test
    public void testNoUserInput() throws Exception {
        this.action = new ExtractConsent();
        this.action.setHttpServletRequest((HttpServletRequest)new MockHttpServletRequest());
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        ConsentContext consentContext = (ConsentContext)this.prc.getSubcontext(ConsentContext.class, false);
        Assert.assertNotNull((Object)consentContext);
        Consent consent1 = (Consent)consentContext.getCurrentConsents().get("consent1");
        Consent consent2 = (Consent)consentContext.getCurrentConsents().get("consent2");
        Assert.assertNotNull((Object)consent1);
        Assert.assertNotNull((Object)consent2);
        Assert.assertFalse((boolean)consent1.isApproved());
        Assert.assertFalse((boolean)consent2.isApproved());
    }

    @Test
    public void testSingleUserInput() throws Exception {
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setParameter("_shib_idp_consentIds", "consent1");
        this.action = new ExtractConsent();
        this.action.setHttpServletRequest((HttpServletRequest)httpServletRequest);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        ConsentContext consentContext = (ConsentContext)this.prc.getSubcontext(ConsentContext.class, false);
        Assert.assertNotNull((Object)consentContext);
        Consent consent1 = (Consent)consentContext.getCurrentConsents().get("consent1");
        Consent consent2 = (Consent)consentContext.getCurrentConsents().get("consent2");
        Assert.assertNotNull((Object)consent1);
        Assert.assertNotNull((Object)consent2);
        Assert.assertTrue((boolean)consent1.isApproved());
        Assert.assertFalse((boolean)consent2.isApproved());
    }

    @Test
    public void testMultipleUserInput() throws Exception {
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.addParameter("_shib_idp_consentIds", "consent1");
        httpServletRequest.addParameter("_shib_idp_consentIds", "consent2");
        this.action = new ExtractConsent();
        this.action.setHttpServletRequest((HttpServletRequest)httpServletRequest);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        ConsentContext consentContext = (ConsentContext)this.prc.getSubcontext(ConsentContext.class, false);
        Assert.assertNotNull((Object)consentContext);
        Consent consent1 = (Consent)consentContext.getCurrentConsents().get("consent1");
        Consent consent2 = (Consent)consentContext.getCurrentConsents().get("consent2");
        Assert.assertNotNull((Object)consent1);
        Assert.assertNotNull((Object)consent2);
        Assert.assertTrue((boolean)consent1.isApproved());
        Assert.assertTrue((boolean)consent2.isApproved());
    }
}

