/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.io.IOException;
import java.util.Map;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.flow.impl.AbstractConsentActionTest;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentStorageAction;
import net.shibboleth.idp.consent.storage.impl.ConsentSerializer;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class AbstractConsentStorageActionTest
extends AbstractConsentActionTest {
    protected void populateAction() throws Exception {
        ((AbstractConsentStorageAction)this.action).setStorageContextLookupStrategy(FunctionSupport.constant((Object)"context"));
        ((AbstractConsentStorageAction)this.action).setStorageKeyLookupStrategy(FunctionSupport.constant((Object)"key"));
    }

    @BeforeMethod
    protected void setUpMemoryStorageService() throws Exception {
        MemoryStorageService storageService = new MemoryStorageService();
        storageService.setId("test");
        storageService.initialize();
        ProfileInterceptorContext pic = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        Assert.assertNotNull((Object)pic);
        Assert.assertNotNull((Object)pic.getAttemptedFlow());
        pic.getAttemptedFlow().setStorageService((StorageService)storageService);
    }

    protected MemoryStorageService getMemoryStorageService() {
        ProfileInterceptorContext pic = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        Assert.assertNotNull((Object)pic);
        Assert.assertNotNull((Object)pic.getAttemptedFlow());
        Assert.assertNotNull((Object)pic.getAttemptedFlow().getStorageService());
        Assert.assertTrue((boolean)(pic.getAttemptedFlow().getStorageService() instanceof MemoryStorageService));
        return (MemoryStorageService)pic.getAttemptedFlow().getStorageService();
    }

    protected Map<String, Consent> readConsentsFromStorage() throws IOException {
        StorageRecord record = this.getMemoryStorageService().read("context", "key");
        Assert.assertNotNull((Object)record);
        ConsentSerializer consentSerializer = (ConsentSerializer)((AbstractConsentStorageAction)this.action).getStorageSerializer();
        Assert.assertNotNull((Object)consentSerializer);
        return consentSerializer.deserialize(0L, "context", "key", record.getValue(), record.getExpiration());
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableInterceptorContextStrategy() throws Exception {
        this.action.initialize();
        ((AbstractConsentStorageAction)this.action).setStorageContextLookupStrategy(null);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableStorageKeyStrategy() throws Exception {
        this.action.initialize();
        ((AbstractConsentStorageAction)this.action).setStorageKeyLookupStrategy(null);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableStorageSerializerStrategy() throws Exception {
        this.action.initialize();
        ((AbstractConsentStorageAction)this.action).setStorageSerializer(null);
    }
}

