/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.storage.impl.ConsentResult;

public class ConsentTestingSupport {
    public static Map<String, Consent> newConsentMap() {
        Consent consent1 = new Consent();
        consent1.setId("consent1");
        consent1.setValue("value1");
        Consent consent2 = new Consent();
        consent2.setId("consent2");
        consent2.setValue("value2");
        HashMap<String, Consent> map = new HashMap<String, Consent>();
        map.put(consent1.getId(), consent1);
        map.put(consent2.getId(), consent2);
        return map;
    }

    public static final Map<String, IdPAttribute> newAttributeMap() {
        return ConsentTestingSupport.newAttributeMap(MapType.SORTED);
    }

    public static final Map<String, IdPAttribute> newAttributeMap(MapType order) {
        List<StringAttributeValue> values;
        StringAttributeValue value1a = new StringAttributeValue("Avalue1");
        StringAttributeValue value1b = new StringAttributeValue("Bvalue1");
        StringAttributeValue value1c = new StringAttributeValue("Cvalue1");
        StringAttributeValue value2 = new StringAttributeValue("value2");
        StringAttributeValue value3 = new StringAttributeValue("value3");
        IdPAttribute attribute1 = new IdPAttribute("attribute1");
        switch (order) {
            default: {
                values = List.of(value1a, value1b, value1c);
                break;
            }
            case ORDER1: {
                values = List.of(value1b, value1a, value1c);
                break;
            }
            case ORDER2: {
                values = List.of(value1c, value1a, value1b);
            }
        }
        attribute1.setValues(values);
        IdPAttribute attribute2 = new IdPAttribute("attribute2");
        attribute2.setValues(Arrays.asList(value1a, value2));
        IdPAttribute attribute3 = new IdPAttribute("attribute3");
        attribute3.setValues(Collections.singletonList(value3));
        HashMap<String, IdPAttribute> map = new HashMap<String, IdPAttribute>();
        map.put(attribute1.getId(), attribute1);
        map.put(attribute2.getId(), attribute2);
        map.put(attribute3.getId(), attribute3);
        return map;
    }

    public static final List<ConsentResult> newConsentResults() {
        ArrayList<ConsentResult> consentResults = new ArrayList<ConsentResult>();
        consentResults.add(new ConsentResult("context1", "key1", "value1", null));
        consentResults.add(new ConsentResult("context2", "key1", "value1", null));
        consentResults.add(new ConsentResult("context2", "key2", "value2", null));
        return consentResults;
    }

    public static Map<String, Integer> newSymbolicsMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("consent1", 101);
        map.put("consent2", 102);
        map.put("attribute1", 201);
        map.put("attribute2", 202);
        map.put("attribute3", 203);
        return map;
    }

    public static enum MapType {
        SORTED,
        ORDER1,
        ORDER2;

    }
}

