/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.idp.consent.impl.ConsentTestingSupport;
import net.shibboleth.idp.consent.logic.impl.GlobalAttributeConsentPredicate;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GlobalAttributeConsentPredicateTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private GlobalAttributeConsentPredicate p;

    @BeforeMethod
    public void setUp() throws Exception {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.p = new GlobalAttributeConsentPredicate();
    }

    @Test
    public void testNullInput() {
        Assert.assertFalse((boolean)this.p.test(null));
    }

    @Test
    public void testNullConsentContext() {
        Assert.assertFalse((boolean)this.p.test(this.prc));
    }

    @Test
    public void testNoPreviousConsents() {
        this.prc.addSubcontext((BaseContext)new ConsentContext());
        Assert.assertFalse((boolean)this.p.test(this.prc));
    }

    @Test
    public void testNonGlobalPreviousConsents() {
        ConsentContext consentContext = new ConsentContext();
        consentContext.getPreviousConsents().putAll(ConsentTestingSupport.newConsentMap());
        this.prc.addSubcontext((BaseContext)consentContext);
        Assert.assertFalse((boolean)this.p.test(this.prc));
    }

    @Test
    public void testApprovedGlobalConsent() {
        Consent globalConsent = new Consent();
        globalConsent.setId("*");
        globalConsent.setApproved(true);
        ConsentContext consentContext = new ConsentContext();
        consentContext.getPreviousConsents().put(globalConsent.getId(), globalConsent);
        this.prc.addSubcontext((BaseContext)consentContext);
        Assert.assertTrue((boolean)this.p.test(this.prc));
    }

    @Test
    public void testNotApprovedGlobalConsent() {
        Consent globalConsent = new Consent();
        globalConsent.setId("*");
        globalConsent.setApproved(false);
        ConsentContext consentContext = new ConsentContext();
        consentContext.getPreviousConsents().put(globalConsent.getId(), globalConsent);
        this.prc.addSubcontext((BaseContext)consentContext);
        Assert.assertFalse((boolean)this.p.test(this.prc));
    }
}

