/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.function.Function;
import net.shibboleth.idp.consent.logic.impl.JoinFunction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JoinFunctionTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private Function<ProfileRequestContext, String> functionA;
    private Function<ProfileRequestContext, String> functionB;
    private JoinFunction function;

    @BeforeMethod
    public void setUp() throws Exception {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.functionA = FunctionSupport.constant((Object)"a");
        this.functionB = FunctionSupport.constant((Object)"b");
    }

    @Test
    public void testNullInput() {
        this.function = new JoinFunction(this.functionA, this.functionB);
        Assert.assertNull((Object)this.function.apply(null));
    }

    @Test
    public void testJoin() {
        this.function = new JoinFunction(this.functionA, this.functionB);
        Assert.assertEquals((String)this.function.apply(this.prc), (String)"a:b");
    }

    @Test
    public void testNullFirstFunctionJoin() {
        this.functionA = FunctionSupport.constant(null);
        this.function = new JoinFunction(this.functionA, this.functionB);
        Assert.assertEquals((String)this.function.apply(this.prc), (String)"b");
    }

    @Test
    public void testNullSecondFunctionJoin() {
        this.functionB = FunctionSupport.constant(null);
        this.function = new JoinFunction(this.functionA, this.functionB);
        Assert.assertEquals((String)this.function.apply(this.prc), (String)"a");
    }

    @Test
    public void testEmptyFirstFunctionJoin() {
        this.functionA = FunctionSupport.constant((Object)"");
        this.function = new JoinFunction(this.functionA, this.functionB);
        Assert.assertEquals((String)this.function.apply(this.prc), (String)":b");
    }

    @Test
    public void testEmptySecondFunctionJoin() {
        this.functionB = FunctionSupport.constant((Object)"");
        this.function = new JoinFunction(this.functionA, this.functionB);
        Assert.assertEquals((String)this.function.apply(this.prc), (String)"a:");
    }
}

