/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.shibboleth.idp.consent.logic.impl.PreferExplicitOrderComparator;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PreferExplicitOrderComparatorTest {
    private Comparator<String> c;
    private List<String> valuesInOrder;
    private List<String> unknownValues;
    private List<String> toBeSorted;
    private List<String> expected;

    @BeforeMethod
    public void setUp() {
        this.valuesInOrder = Arrays.asList("first", "middle", "last");
        this.unknownValues = Arrays.asList("some", "unknown", "values");
        this.expected = new ArrayList<String>();
        this.expected.addAll(this.valuesInOrder);
        this.expected.addAll(this.unknownValues);
        this.toBeSorted = new ArrayList<String>();
        this.toBeSorted.addAll(this.valuesInOrder);
        this.toBeSorted.addAll(this.unknownValues);
        Collections.shuffle(this.toBeSorted);
    }

    @Test(invocationCount=10)
    public void testExplicitOrdering() {
        Collections.shuffle(this.toBeSorted);
        this.c = new PreferExplicitOrderComparator(this.valuesInOrder);
        Collections.sort(this.toBeSorted, this.c);
        Assert.assertEquals(this.toBeSorted, this.expected);
    }

    @Test
    public void testExplicitOrderingWithDuplicateValuesInConstructor() {
        this.c = new PreferExplicitOrderComparator(Arrays.asList("first", "middle", "last", "middle"));
        Collections.sort(this.toBeSorted, this.c);
        Assert.assertEquals(this.toBeSorted, this.expected);
    }

    @Test
    public void testExplicitOrderingWithEmptyValuesInConstructor() {
        this.c = new PreferExplicitOrderComparator(Arrays.asList("first", "", "middle", " ", "last"));
        Collections.sort(this.toBeSorted, this.c);
        Assert.assertEquals(this.toBeSorted, this.expected);
    }

    @Test
    public void testExplicitOrderingWithKnownValuesOnly() {
        this.toBeSorted = new ArrayList<String>(this.valuesInOrder);
        Collections.shuffle(this.toBeSorted);
        this.c = new PreferExplicitOrderComparator(this.valuesInOrder);
        Collections.sort(this.toBeSorted, this.c);
        Assert.assertEquals(this.toBeSorted, this.valuesInOrder);
    }

    @Test
    public void testExplicitOrderingWithNullValuesInConstructor() {
        this.c = new PreferExplicitOrderComparator(Arrays.asList("first", null, "middle", "last"));
        Collections.sort(this.toBeSorted, this.c);
        Assert.assertEquals(this.toBeSorted, this.expected);
    }

    @Test
    public void testExplicitOrderingWithWhitespaceInConstructor() {
        this.c = new PreferExplicitOrderComparator(Arrays.asList(" first ", "\tmiddle", "last\n"));
        Collections.sort(this.toBeSorted, this.c);
        Assert.assertEquals(this.toBeSorted, this.expected);
    }

    @Test
    public void testNaturalOrderingWithEmptyConstructor() {
        Collections.sort(this.expected);
        this.c = new PreferExplicitOrderComparator(Collections.emptyList());
        Collections.sort(this.toBeSorted, this.c);
        Assert.assertEquals(this.toBeSorted, this.expected);
    }

    @Test
    public void testNaturalOrderingWithNoKnownValues() {
        Collections.sort(this.expected);
        this.c = new PreferExplicitOrderComparator(Arrays.asList("not", "known"));
        Collections.sort(this.toBeSorted, this.c);
        Assert.assertEquals(this.toBeSorted, this.expected);
    }

    @Test
    public void testNaturalOrderingWithNullConstructor() {
        Collections.sort(this.expected);
        this.c = new PreferExplicitOrderComparator(null);
        Collections.sort(this.toBeSorted, this.c);
        Assert.assertEquals(this.toBeSorted, this.expected);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullValuesToBeSorted() {
        this.toBeSorted.add(null);
        Collections.shuffle(this.toBeSorted);
        this.c = new PreferExplicitOrderComparator(this.valuesInOrder);
        Collections.sort(this.toBeSorted, this.c);
    }
}

