/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.storage.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.shibboleth.idp.consent.storage.impl.CollectionSerializer;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CollectionSerializerTest {
    protected CollectionSerializer serializer;

    @BeforeMethod
    public void setUp() throws Exception {
        this.serializer = new CollectionSerializer();
        this.serializer.initialize();
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNull() throws Exception {
        this.serializer.serialize(null);
    }

    @Test
    public void testEmpty() throws Exception {
        Assert.assertEquals((String)this.serializer.serialize(new ArrayList()), (String)"[]");
        Assert.assertEquals((Collection)this.serializer.deserialize(-1L, "context", "key", "[]", null), Collections.emptyList());
    }

    @Test
    public void testNullValue() throws Exception {
        Assert.assertEquals((String)this.serializer.serialize(Collections.singletonList(null)), (String)"[]");
        Assert.assertEquals((Collection)this.serializer.deserialize(-1L, "context", "key", "[null]", null), Collections.emptyList());
    }

    @Test
    public void testSimple() throws IOException {
        List<String> collection = Arrays.asList("element1", "element2", "element3");
        String serialized = this.serializer.serialize(collection);
        Assert.assertEquals((String)serialized, (String)"[\"element1\",\"element2\",\"element3\"]");
        Collection deserialized = this.serializer.deserialize(-1L, "context", "key", serialized, null);
        Assert.assertEquals((Collection)deserialized, collection);
    }
}

