/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.ext.spring.util.SpringSupport;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;

public abstract class AbstractAttributeDisplayFunction
implements Function<IdPAttribute, String> {
    @Nonnull
    @Unmodifiable
    private final List<Locale.LanguageRange> languageRange;
    @Nonnull
    @Unmodifiable
    private final List<Locale.LanguageRange> defaultLanguageRange;
    @Nonnull
    private Map<IdPAttribute, Map<Locale, String>> cachedInfo = new HashMap<IdPAttribute, Map<Locale, String>>();
    @Nonnull
    private ReloadableService<AttributeTranscoderRegistry> transcoder;

    public AbstractAttributeDisplayFunction(@Nonnull HttpServletRequest request, @Nullable List<String> defaultLanguages, ReloadableService<AttributeTranscoderRegistry> transcoderService) {
        this.languageRange = SpringSupport.getLanguageRange((HttpServletRequest)request);
        this.transcoder = (ReloadableService)Constraint.isNotNull(transcoderService, (String)"Injected transocde service should be non-null");
        this.defaultLanguageRange = defaultLanguages == null || defaultLanguages.isEmpty() ? Collections.emptyList() : defaultLanguages.stream().map(StringSupport::trimOrNull).filter(e -> e != null).map(s -> new Locale.LanguageRange((String)s)).collect(Collectors.toUnmodifiableList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String apply(@Nullable IdPAttribute input) {
        Locale locale;
        if (input == null) {
            return "N/A";
        }
        Map<Locale, String> displayInfo = this.cachedInfo.get(input);
        if (displayInfo == null) {
            ServiceableComponent component = null;
            try {
                component = this.transcoder.getServiceableComponent();
                if (component != null) {
                    displayInfo = this.getDisplayInfo((AttributeTranscoderRegistry)component.getComponent(), input);
                }
            }
            finally {
                if (component != null) {
                    component.unpinComponent();
                }
            }
            this.cachedInfo.put(input, displayInfo);
        }
        if ((locale = Locale.lookup(this.languageRange, displayInfo.keySet())) == null) {
            locale = Locale.lookup(this.defaultLanguageRange, displayInfo.keySet());
        }
        if (locale == null) {
            return input.getId();
        }
        String result = displayInfo.get(locale);
        if (result == null) {
            return input.getId();
        }
        return result;
    }

    @Nonnull
    protected abstract Map<Locale, String> getDisplayInfo(@Nonnull AttributeTranscoderRegistry var1, @Nonnull IdPAttribute var2);
}

