/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.consent.logic.impl.AbstractAttributeDisplayFunction;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeDisplayNameFunction
extends AbstractAttributeDisplayFunction {
    private final Logger log = LoggerFactory.getLogger(AttributeDisplayNameFunction.class);

    public AttributeDisplayNameFunction(@Nonnull HttpServletRequest request, @Nullable List<String> defaultLangauages, ReloadableService<AttributeTranscoderRegistry> transcoderService) {
        super(request, defaultLangauages, transcoderService);
    }

    @Override
    @Nonnull
    protected Map<Locale, String> getDisplayInfo(@Nonnull AttributeTranscoderRegistry registry, @Nonnull IdPAttribute attribute) {
        Map fromAttribute = attribute.getDisplayNames();
        if (fromAttribute != null && !fromAttribute.isEmpty()) {
            this.log.debug("Attribute {} carried locally defined names, skipping the registry", (Object)attribute.getId());
            return fromAttribute;
        }
        return registry.getDisplayNames(attribute);
    }
}

