/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class PreferExplicitOrderComparator
implements Comparator<String> {
    @Nullable
    private Ordering<String> explicitOrdering;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    private List<String> explicitOrder;

    public PreferExplicitOrderComparator(@Nullable @NullableElements List<String> order) {
        if (order == null) {
            this.explicitOrder = Collections.emptyList();
        } else {
            this.explicitOrder = order.stream().map(StringSupport::trimOrNull).filter(e -> e != null).distinct().collect(Collectors.toUnmodifiableList());
            this.explicitOrdering = Ordering.explicit(this.explicitOrder);
        }
    }

    @Override
    public int compare(String o1, String o2) {
        boolean containsLeft = this.explicitOrder.contains(o1);
        boolean containsRight = this.explicitOrder.contains(o2);
        if (containsLeft && containsRight) {
            return this.explicitOrdering.compare((Object)o1, (Object)o2);
        }
        if (containsLeft) {
            return -1;
        }
        if (containsRight) {
            return 1;
        }
        return Ordering.natural().compare((Object)o1, (Object)o2);
    }
}

