/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.ar.impl;

import java.util.function.Function;
import net.shibboleth.idp.consent.flow.ar.impl.AttributeReleaseFlowDescriptor;
import net.shibboleth.idp.consent.logic.impl.AttributeValuesHashFunction;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeReleaseFlowDescriptorTest {
    private AttributeReleaseFlowDescriptor descriptor;

    @BeforeMethod
    public void setUp() {
        this.descriptor = new AttributeReleaseFlowDescriptor();
        this.descriptor.setId("test");
    }

    @Test
    public void testInstantation() {
        Assert.assertEquals((String)this.descriptor.getId(), (String)"test");
        Assert.assertFalse((boolean)this.descriptor.isDoNotRememberConsentAllowed());
        Assert.assertFalse((boolean)this.descriptor.isGlobalConsentAllowed());
        Assert.assertFalse((boolean)this.descriptor.isPerAttributeConsentEnabled());
        Assert.assertNotNull((Object)this.descriptor.getAttributeValuesHashFunction());
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullAttributeValuesHashFunction() {
        this.descriptor.setAttributeValuesHashFunction(null);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testSettingAttributeValuesHashFunctionAfterInitialization() throws Exception {
        this.descriptor.initialize();
        this.descriptor.setAttributeValuesHashFunction((Function)new AttributeValuesHashFunction());
    }

    @Test
    public void testSettingAttributeValuesHashFunction() throws Exception {
        AttributeValuesHashFunction function = new AttributeValuesHashFunction();
        this.descriptor.setAttributeValuesHashFunction((Function)function);
        Assert.assertEquals((Object)this.descriptor.getAttributeValuesHashFunction(), (Object)function);
    }

    @Test
    public void testMutatingDoNotRememberConsent() throws Exception {
        this.descriptor.setDoNotRememberConsentAllowed(true);
        Assert.assertTrue((boolean)this.descriptor.isDoNotRememberConsentAllowed());
        this.descriptor.setDoNotRememberConsentAllowed(false);
        Assert.assertFalse((boolean)this.descriptor.isDoNotRememberConsentAllowed());
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testSettingDoNotRememberConsentAfterInitialization() throws Exception {
        this.descriptor.initialize();
        this.descriptor.setDoNotRememberConsentAllowed(true);
    }

    @Test
    public void testMutatingGlobalConsent() {
        this.descriptor.setGlobalConsentAllowed(true);
        Assert.assertTrue((boolean)this.descriptor.isGlobalConsentAllowed());
        this.descriptor.setGlobalConsentAllowed(false);
        Assert.assertFalse((boolean)this.descriptor.isGlobalConsentAllowed());
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testSettingGlobalConsentAfterInitialization() throws Exception {
        this.descriptor.initialize();
        this.descriptor.setGlobalConsentAllowed(true);
    }

    @Test
    public void testMutatingPerAttributeConsent() {
        this.descriptor.setPerAttributeConsentEnabled(true);
        Assert.assertTrue((boolean)this.descriptor.isPerAttributeConsentEnabled());
        this.descriptor.setPerAttributeConsentEnabled(false);
        Assert.assertFalse((boolean)this.descriptor.isPerAttributeConsentEnabled());
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testSettingPerAttributeConsentAfterInitialization() throws Exception {
        this.descriptor.initialize();
        this.descriptor.setPerAttributeConsentEnabled(true);
    }
}

