/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.util.Map;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentStorageAction;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentStorageActionTest;
import net.shibboleth.idp.consent.flow.storage.impl.ReadConsentFromStorage;
import net.shibboleth.idp.consent.impl.ConsentTestingSupport;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import org.opensaml.storage.impl.MemoryStorageService;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ReadConsentFromStorageTest
extends AbstractConsentStorageActionTest {
    @BeforeMethod
    public void setUpAction() throws Exception {
        this.action = new ReadConsentFromStorage();
        this.populateAction();
    }

    @Test
    public void testReadConsentFromStorage() throws Exception {
        MemoryStorageService ss = this.getMemoryStorageService();
        ss.create("context", "key", ConsentTestingSupport.newConsentMap(), ((AbstractConsentStorageAction)this.action).getStorageSerializer(), null);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        ConsentContext consentCtx = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        Assert.assertNotNull((Object)consentCtx);
        Assert.assertEquals((Map)consentCtx.getPreviousConsents(), ConsentTestingSupport.newConsentMap());
    }

    @Test
    public void testReadEmptyStorage() throws Exception {
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        ConsentContext consentCtx = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        Assert.assertNotNull((Object)consentCtx);
        Assert.assertTrue((boolean)consentCtx.getPreviousConsents().isEmpty());
    }
}

