/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.XMLObjectAttributeValue;
import net.shibboleth.idp.consent.impl.ConsentTestingSupport;
import net.shibboleth.idp.consent.logic.impl.AttributeValuesHashFunction;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSString;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeValuesHashFunctionTest
extends XMLObjectBaseTestCase {
    private AttributeValuesHashFunction function;

    @BeforeMethod
    public void setUp() {
        this.function = new AttributeValuesHashFunction();
    }

    @Test
    public void testNullInput() {
        Assert.assertNull((Object)this.function.apply(null));
    }

    @Test
    public void testEmptyInput() {
        Assert.assertNull((Object)this.function.apply(Collections.emptyList()));
    }

    @Test(enabled=true)
    public void testNullValue() {
        Assert.assertEquals((String)this.function.apply(List.of(EmptyAttributeValue.NULL)), (String)"QlRl6kTdT/0tD4h3xpwJn+hoFjZssUN15Bc6DO/CXws=");
    }

    @Test(enabled=true)
    public void testEmptyValue() {
        Assert.assertEquals((String)this.function.apply(List.of(EmptyAttributeValue.ZERO_LENGTH)), (String)"vwBWiidH5q5XZY3uEPcnJYeDTgqJnpV9WpmgWZS9wR4=");
    }

    @Test
    public void testSingleValue() {
        String hash = this.function.apply((Collection)ConsentTestingSupport.newAttributeMap().get("attribute1").getValues());
        Assert.assertEquals((String)hash, (String)"qY1Ely22YLjD7hy4/HFSlErfjWNtVNJTZDral2Bs3Q8=");
    }

    @Test
    public void testMultipleValues() {
        String hash = this.function.apply((Collection)ConsentTestingSupport.newAttributeMap().get("attribute2").getValues());
        Assert.assertEquals((String)hash, (String)"w4A7kgpy8PAiMfNkM8yR68zLF9ngILQDWDy+n2l59zk=");
    }

    @Test
    public void testScoped() {
        ScopedStringAttributeValue val = new ScopedStringAttributeValue("Value", "Scope");
        Assert.assertEquals((String)this.function.apply(Collections.singletonList(val)), (String)"WFoLzGdi3WmUjhWe3Q6uSyoHVZJXukDWeOUb7CyH5V8=");
    }

    @Test
    public void testByte() {
        byte[] theBytes = new byte[]{1, 2, 3};
        ByteAttributeValue val = new ByteAttributeValue(theBytes);
        Assert.assertEquals((String)this.function.apply(Collections.singletonList(val)), (String)"saP1UTQcyQPZHOPI6tVhVWMKOmB3BDCTn/l5QFSsyX4=");
    }

    @Test
    public void testXML() {
        XMLObjectBuilder builder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(XSString.TYPE_NAME);
        XSString xmlString = (XSString)builder.buildObject(XSString.TYPE_NAME);
        xmlString.setValue("value");
        XMLObjectAttributeValue val = new XMLObjectAttributeValue((XMLObject)xmlString);
        Assert.assertEquals((String)this.function.apply(Collections.singletonList(val)), (String)"c+NqWOijlvFBpla4r1q3F0RkpYZK7phCNe2gKb0r57o=");
    }

    private IdPAttributeValue testAV(final Object type) {
        return new IdPAttributeValue(){

            public Object getNativeValue() {
                return type;
            }

            public String getDisplayValue() {
                return "Display";
            }
        };
    }

    @Test
    public void unknownTypeValue() {
        Assert.assertEquals((String)this.function.apply(Collections.singletonList(this.testAV("42"))), (String)"Lt6BAjtq4qQJ6ADEZKf/s5XZxzBh6mShY/UCphriugY=");
    }

    @Test
    public void unknownTypeNoValue() {
        Assert.assertEquals((String)this.function.apply(Collections.singletonList(this.testAV(null))), (String)"xPtMT+sJsVtAtjNLzPrBBlfbY/yUsAQ7Ncxxc7Q5k70=");
    }
}

