/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import net.shibboleth.idp.consent.flow.ar.impl.AttributeReleaseFlowDescriptor;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.idp.consent.logic.impl.FlowDescriptorLookupFunction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FlowDescriptorLookupFunctionTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private ProfileInterceptorContext pic;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.pic = new ProfileInterceptorContext();
        this.prc.addSubcontext((BaseContext)this.pic);
    }

    @Test
    public void testLookup() {
        this.pic.setAttemptedFlow((ProfileInterceptorFlowDescriptor)new ConsentFlowDescriptor());
        FlowDescriptorLookupFunction strategy = new FlowDescriptorLookupFunction(ConsentFlowDescriptor.class);
        ConsentFlowDescriptor flow = (ConsentFlowDescriptor)strategy.apply(this.prc);
        Assert.assertNotNull((Object)flow);
    }

    @Test
    public void testLookupChild() {
        this.pic.setAttemptedFlow((ProfileInterceptorFlowDescriptor)new ConsentFlowDescriptor());
        FlowDescriptorLookupFunction strategy = new FlowDescriptorLookupFunction(AttributeReleaseFlowDescriptor.class);
        AttributeReleaseFlowDescriptor flow = (AttributeReleaseFlowDescriptor)strategy.apply(this.prc);
        Assert.assertNull((Object)flow);
    }

    @Test
    public void testLookupParent() {
        this.pic.setAttemptedFlow((ProfileInterceptorFlowDescriptor)new AttributeReleaseFlowDescriptor());
        FlowDescriptorLookupFunction strategy = new FlowDescriptorLookupFunction(ConsentFlowDescriptor.class);
        ConsentFlowDescriptor flow = (ConsentFlowDescriptor)strategy.apply(this.prc);
        Assert.assertNotNull((Object)flow);
    }

    @Test
    public void testNullInput() {
        FlowDescriptorLookupFunction strategy = new FlowDescriptorLookupFunction(ConsentFlowDescriptor.class);
        ConsentFlowDescriptor flow = (ConsentFlowDescriptor)strategy.apply(null);
        Assert.assertNull((Object)flow);
    }

    @Test
    public void testNoInterceptorContext() {
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        FlowDescriptorLookupFunction strategy = new FlowDescriptorLookupFunction(ConsentFlowDescriptor.class);
        ConsentFlowDescriptor flow = (ConsentFlowDescriptor)strategy.apply(null);
        Assert.assertNull((Object)flow);
    }

    @Test
    public void testNoAttemptedFlow() {
        FlowDescriptorLookupFunction strategy = new FlowDescriptorLookupFunction(ConsentFlowDescriptor.class);
        ConsentFlowDescriptor flow = (ConsentFlowDescriptor)strategy.apply(null);
        Assert.assertNull((Object)flow);
    }
}

