/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.idp.consent.logic.impl.MessageSourceConsentFunction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MessageSourceConsentFunctionTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private MessageSource messageSource;
    private MessageSourceConsentFunction function;

    @BeforeMethod
    public void setUp() throws Exception {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.messageSource = new MockMessageSource();
        this.function = new MessageSourceConsentFunction();
        this.function.setMessageSource(this.messageSource);
    }

    private void setUpDescriptor(boolean compareValues) {
        ConsentFlowDescriptor descriptor = new ConsentFlowDescriptor();
        descriptor.setId("test");
        descriptor.setCompareValues(compareValues);
        ProfileInterceptorContext pic = new ProfileInterceptorContext();
        pic.setAttemptedFlow((ProfileInterceptorFlowDescriptor)descriptor);
        this.prc.addSubcontext((BaseContext)pic);
        Assert.assertNotNull((Object)this.prc.getSubcontext(ProfileInterceptorContext.class));
        Assert.assertNotNull((Object)((ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class)).getAttemptedFlow());
        Assert.assertTrue((boolean)(((ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class)).getAttemptedFlow() instanceof ConsentFlowDescriptor));
        Assert.assertEquals((boolean)((ConsentFlowDescriptor)((ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class)).getAttemptedFlow()).compareValues(), (boolean)compareValues);
    }

    @Test
    public void testNullInput() {
        Assert.assertNull((Object)this.function.apply(null));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullIdMessageCode() throws Exception {
        this.function.setConsentKeyLookupStrategy(null);
        this.function.initialize();
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullValueMessageCode() throws Exception {
        this.function.setConsentValueMessageCodeSuffix(null);
        this.function.initialize();
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testEmptyValueMessageCode() throws Exception {
        this.function.setConsentValueMessageCodeSuffix("");
        this.function.initialize();
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testInstantiationIdMessageCode() throws Exception {
        this.function.setConsentKeyLookupStrategy(FunctionSupport.constant((Object)"consentIdMessageCode"));
        this.function.initialize();
        this.function.setConsentKeyLookupStrategy(FunctionSupport.constant((Object)"consentIdMessageCode"));
    }

    @Test
    public void testMessageSourceConsent() throws Exception {
        this.setUpDescriptor(false);
        this.function.setConsentKeyLookupStrategy(FunctionSupport.constant((Object)"key"));
        this.function.initialize();
        Consent consent = new Consent();
        consent.setId("id");
        HashMap<String, Consent> expected = new HashMap<String, Consent>();
        expected.put(consent.getId(), consent);
        Assert.assertEquals((Map)this.function.apply(this.prc), expected);
    }

    @Test
    public void testMessageSourceConsentCompareValues() throws Exception {
        this.setUpDescriptor(true);
        this.function.setConsentKeyLookupStrategy(FunctionSupport.constant((Object)"key"));
        this.function.initialize();
        Consent consent = new Consent();
        consent.setId("id");
        consent.setValue((String)this.function.getHashFunction().apply("value"));
        HashMap<String, Consent> expected = new HashMap<String, Consent>();
        expected.put(consent.getId(), consent);
        Assert.assertEquals((Map)this.function.apply(this.prc), expected);
    }

    private class MockMessageSource
    implements MessageSource {
        private MockMessageSource() {
        }

        public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
            if (code.equals("key")) {
                return "id";
            }
            if (code.equals("id.text")) {
                return "value";
            }
            return defaultMessage;
        }

        public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
            if (code.equals("key")) {
                return "id";
            }
            if (code.equals("id.text")) {
                return "value";
            }
            throw new NoSuchMessageException("No such message");
        }

        public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
            if (resolvable.getCodes()[0].equals("key")) {
                return "id";
            }
            if (resolvable.getCodes()[0].equals("id.text")) {
                return "value";
            }
            throw new NoSuchMessageException("No such message");
        }
    }
}

