/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.utilities.java.support.logic.Predicate;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalAttributeConsentPredicate
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(GlobalAttributeConsentPredicate.class);
    @Nonnull
    private Function<ProfileRequestContext, ConsentContext> consentContextlookupStrategy = new ChildContextLookup(ConsentContext.class);

    public boolean test(@Nullable ProfileRequestContext input) {
        if (input == null) {
            return false;
        }
        ConsentContext consentContext = this.consentContextlookupStrategy.apply(input);
        if (consentContext == null) {
            return false;
        }
        Map previousConsents = consentContext.getPreviousConsents();
        for (Consent consent : previousConsents.values()) {
            if (!consent.getId().equals("*") || !consent.isApproved()) continue;
            return true;
        }
        return false;
    }
}

