/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.AttributeReleaseContext;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.idp.consent.flow.ar.impl.AttributeReleaseFlowDescriptor;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.idp.consent.logic.impl.FlowDescriptorLookupFunction;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class AttributeReleaseConsentFunction
implements Function<ProfileRequestContext, Map<String, Consent>> {
    @Nonnull
    private Function<ProfileRequestContext, ConsentContext> consentContextLookupStrategy = new ChildContextLookup(ConsentContext.class);
    @Nonnull
    private Function<ProfileRequestContext, ConsentFlowDescriptor> consentFlowDescriptorLookupStrategy = new FlowDescriptorLookupFunction<ConsentFlowDescriptor>(ConsentFlowDescriptor.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeReleaseContext> attributeReleaseContextLookupStrategy = new ChildContextLookup(AttributeReleaseContext.class);

    public void setConsentContextLookupStrategy(@Nonnull Function<ProfileRequestContext, ConsentContext> strategy) {
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Consent context lookup strategy cannot be null");
    }

    public void setConsentFlowDescriptorLookupStrategy(@Nonnull Function<ProfileRequestContext, ConsentFlowDescriptor> strategy) {
        this.consentFlowDescriptorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Consent flow descriptor lookup strategy cannot be null");
    }

    public void setAttributeReleaseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeReleaseContext> strategy) {
        this.attributeReleaseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Attribute release context lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public Map<String, Consent> apply(@Nullable ProfileRequestContext input) {
        if (input == null) {
            return null;
        }
        ConsentFlowDescriptor consentFlowDescriptor = this.consentFlowDescriptorLookupStrategy.apply(input);
        if (consentFlowDescriptor == null || !(consentFlowDescriptor instanceof AttributeReleaseFlowDescriptor)) {
            return null;
        }
        ConsentContext consentContext = this.consentContextLookupStrategy.apply(input);
        if (consentContext == null) {
            return null;
        }
        AttributeReleaseContext attributeReleaseContext = this.attributeReleaseContextLookupStrategy.apply(input);
        if (attributeReleaseContext == null) {
            return null;
        }
        LinkedHashMap<String, Consent> currentConsents = new LinkedHashMap<String, Consent>();
        Map consentableAttributes = attributeReleaseContext.getConsentableAttributes();
        for (IdPAttribute attribute : consentableAttributes.values()) {
            Consent previousConsent;
            Consent consent = new Consent();
            Consent unsortedConsent = new Consent();
            consent.setId(attribute.getId());
            if (consentFlowDescriptor.compareValues()) {
                unsortedConsent.setValue(((AttributeReleaseFlowDescriptor)consentFlowDescriptor).getAttributeValuesHashFunction().apply(attribute.getValues()));
                ArrayList sorted = new ArrayList(attribute.getValues());
                Collections.sort(sorted);
                consent.setValue(((AttributeReleaseFlowDescriptor)consentFlowDescriptor).getAttributeValuesHashFunction().apply(sorted));
            }
            if ((previousConsent = (Consent)consentContext.getPreviousConsents().get(consent.getId())) != null) {
                if (consentFlowDescriptor.compareValues()) {
                    if (Objects.equals(consent.getValue(), previousConsent.getValue())) {
                        consent.setApproved(previousConsent.isApproved());
                    } else if (Objects.equals(unsortedConsent.getValue(), previousConsent.getValue())) {
                        consent.setApproved(previousConsent.isApproved());
                    }
                } else {
                    consent.setApproved(previousConsent.isApproved());
                }
            }
            currentConsents.put(consent.getId(), consent);
        }
        return currentConsents;
    }
}

