/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.ar.impl;

import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.consent.context.AttributeReleaseContext;
import net.shibboleth.idp.consent.flow.ar.impl.AbstractAttributeReleaseActionTest;
import net.shibboleth.idp.consent.flow.ar.impl.PopulateAttributeReleaseContext;
import net.shibboleth.idp.consent.impl.ConsentTestingSupport;
import net.shibboleth.idp.consent.logic.impl.PreferExplicitOrderComparator;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PopulateAttributeReleaseContextTest
extends AbstractAttributeReleaseActionTest {
    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testMissingPredicate() throws Exception {
        this.action = new PopulateAttributeReleaseContext();
        this.action.initialize();
    }

    @Test
    public void testObtainConsentForAllAttributes() throws Exception {
        this.action = new PopulateAttributeReleaseContext();
        ((PopulateAttributeReleaseContext)this.action).setAttributePredicate(e -> true);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AttributeReleaseContext arc = (AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class);
        assert (arc != null);
        Assert.assertEquals((Map)arc.getConsentableAttributes(), ConsentTestingSupport.newAttributeMap());
    }

    @Test
    public void testObtainConsentForSomeAttributes() throws Exception {
        this.action = new PopulateAttributeReleaseContext();
        ((PopulateAttributeReleaseContext)this.action).setAttributePredicate((Predicate)new MockIdPAttributePredicate());
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AttributeReleaseContext arc = (AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class);
        assert (arc != null);
        Assert.assertNotEquals((Map)arc.getConsentableAttributes(), ConsentTestingSupport.newAttributeMap());
        Assert.assertTrue((boolean)arc.getConsentableAttributes().containsKey("attribute1"));
        Assert.assertTrue((boolean)arc.getConsentableAttributes().containsKey("attribute2"));
        Assert.assertFalse((boolean)arc.getConsentableAttributes().containsKey("attribute3"));
    }

    @Test
    public void testDefaultNaturalAttributeOrdering() throws Exception {
        TreeMap<String, IdPAttribute> orderedAttributes = new TreeMap<String, IdPAttribute>((Comparator<String>)Ordering.natural());
        orderedAttributes.putAll(ConsentTestingSupport.newAttributeMap());
        this.action = new PopulateAttributeReleaseContext();
        ((PopulateAttributeReleaseContext)this.action).setAttributePredicate(e -> true);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AttributeReleaseContext arc = (AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class);
        assert (arc != null);
        Assert.assertEquals((Map)arc.getConsentableAttributes(), orderedAttributes);
    }

    @Test
    public void testExplicitAttributeOrderingWithKnownAttributesOnly() throws Exception {
        List attributeOrder = CollectionSupport.listOf((Object[])new String[]{"attribute2", "attribute3", "attribute1"});
        TreeMap<String, IdPAttribute> orderedAttributes = new TreeMap<String, IdPAttribute>((Comparator<String>)Ordering.explicit((List)attributeOrder));
        orderedAttributes.putAll(ConsentTestingSupport.newAttributeMap());
        this.action = new PopulateAttributeReleaseContext();
        ((PopulateAttributeReleaseContext)this.action).setAttributePredicate(e -> true);
        ((PopulateAttributeReleaseContext)this.action).setAttributeIdComparator((Comparator)new PreferExplicitOrderComparator(attributeOrder));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AttributeReleaseContext arc = (AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class);
        assert (arc != null);
        Assert.assertEquals((Map)arc.getConsentableAttributes(), orderedAttributes);
    }

    @Test
    public void testExplicitAttributeOrderingWithUnknownAttributes() throws Exception {
        List attributeOrder = CollectionSupport.listOf((Object)"attribute3", (Object)"attribute2");
        IdPAttribute attribute4 = new IdPAttribute("attribute4");
        attribute4.setValues(CollectionSupport.singletonList((Object)new StringAttributeValue("value4")));
        LinkedHashMap<String, IdPAttribute> orderedAttributes = new LinkedHashMap<String, IdPAttribute>();
        orderedAttributes.put("attribute3", ConsentTestingSupport.newAttributeMap().get("attribute3"));
        orderedAttributes.put("attribute2", ConsentTestingSupport.newAttributeMap().get("attribute2"));
        orderedAttributes.put("attribute1", ConsentTestingSupport.newAttributeMap().get("attribute1"));
        orderedAttributes.put("attribute4", attribute4);
        ArrayList<IdPAttribute> attributes = new ArrayList<IdPAttribute>();
        attributes.addAll(ConsentTestingSupport.newAttributeMap().values());
        attributes.add(attribute4);
        RelyingPartyContext rpCtx = (RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class);
        assert (rpCtx != null);
        AttributeContext ac = (AttributeContext)rpCtx.getSubcontext(AttributeContext.class);
        assert (ac != null);
        ac.setIdPAttributes(attributes);
        this.action = new PopulateAttributeReleaseContext();
        ((PopulateAttributeReleaseContext)this.action).setAttributePredicate(e -> true);
        ((PopulateAttributeReleaseContext)this.action).setAttributeIdComparator((Comparator)new PreferExplicitOrderComparator(attributeOrder));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AttributeReleaseContext arc = (AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class);
        assert (arc != null);
        Assert.assertEquals((Map)arc.getConsentableAttributes(), orderedAttributes);
    }

    @Test
    public void testMissingAttributeContext() throws Exception {
        RelyingPartyContext ctx = (RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class);
        assert (ctx != null);
        ctx.removeSubcontext(AttributeContext.class);
        this.action = new PopulateAttributeReleaseContext();
        ((PopulateAttributeReleaseContext)this.action).setAttributePredicate(e -> true);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidAttributeContext");
    }

    private class MockIdPAttributePredicate
    implements Predicate<IdPAttribute> {
        private MockIdPAttributePredicate() {
        }

        @Override
        public boolean test(@Nullable IdPAttribute input) {
            assert (input != null);
            return input.getId().equals("attribute1") || input.getId().equals("attribute2");
        }
    }
}

