/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.impl;

import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.idp.consent.flow.impl.AbstractConsentActionTest;
import net.shibboleth.idp.consent.flow.impl.ExtractConsent;
import net.shibboleth.idp.consent.impl.ConsentTestingSupport;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.testing.ConstantSupplier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExtractConsentTest
extends AbstractConsentActionTest {
    @BeforeMethod
    public void setUpCurrentConsents() throws Exception {
        ConsentContext consentContext = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        assert (consentContext != null);
        consentContext.getCurrentConsents().putAll(ConsentTestingSupport.newConsentMap());
    }

    @Test
    public void testMissingHttpServletRequest() throws Exception {
        this.action = new ExtractConsent();
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
        ConsentContext consentContext = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        assert (consentContext != null);
        Consent consent1 = (Consent)consentContext.getCurrentConsents().get("consent1");
        Consent consent2 = (Consent)consentContext.getCurrentConsents().get("consent2");
        assert (consent1 != null && consent2 != null);
        Assert.assertNotNull((Object)consent2);
        Assert.assertFalse((boolean)consent1.isApproved());
        Assert.assertFalse((boolean)consent2.isApproved());
    }

    @Test
    public void testNoUserInput() throws Exception {
        this.action = new ExtractConsent();
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)request));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        ConsentContext consentContext = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        assert (consentContext != null);
        Consent consent1 = (Consent)consentContext.getCurrentConsents().get("consent1");
        Consent consent2 = (Consent)consentContext.getCurrentConsents().get("consent2");
        Assert.assertNotNull((Object)consent1);
        Assert.assertNotNull((Object)consent2);
        Assert.assertFalse((boolean)consent1.isApproved());
        Assert.assertFalse((boolean)consent2.isApproved());
    }

    @Test
    public void testSingleUserInput() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("_shib_idp_consentIds", "consent1");
        this.action = new ExtractConsent();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)request));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        ConsentContext consentContext = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        assert (consentContext != null);
        Consent consent1 = (Consent)consentContext.getCurrentConsents().get("consent1");
        Consent consent2 = (Consent)consentContext.getCurrentConsents().get("consent2");
        Assert.assertNotNull((Object)consent1);
        Assert.assertNotNull((Object)consent2);
        Assert.assertTrue((boolean)consent1.isApproved());
        Assert.assertFalse((boolean)consent2.isApproved());
    }

    @Test
    public void testMultipleUserInput() throws Exception {
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.addParameter("_shib_idp_consentIds", "consent1");
        httpServletRequest.addParameter("_shib_idp_consentIds", "consent2");
        this.action = new ExtractConsent();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)httpServletRequest));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        ConsentContext consentContext = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        assert (consentContext != null);
        Consent consent1 = (Consent)consentContext.getCurrentConsents().get("consent1");
        Consent consent2 = (Consent)consentContext.getCurrentConsents().get("consent2");
        Assert.assertNotNull((Object)consent1);
        Assert.assertNotNull((Object)consent2);
        Assert.assertTrue((boolean)consent1.isApproved());
        Assert.assertTrue((boolean)consent2.isApproved());
    }
}

