/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentIndexedStorageAction;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentStorageActionTest;
import net.shibboleth.idp.consent.storage.impl.CollectionSerializer;
import net.shibboleth.shared.component.UnmodifiableComponentException;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractConsentIndexedStorageActionTest
extends AbstractConsentStorageActionTest {
    private Object nullObj;

    @Override
    protected void populateAction() throws Exception {
        super.populateAction();
        ((AbstractConsentIndexedStorageAction)this.action).setStorageIndexKeyLookupStrategy(FunctionSupport.constant((Object)"_index"));
    }

    protected Collection<String> readStorageKeysFromIndex() throws IOException {
        StorageRecord index = this.getMemoryStorageService().read("context", "_index");
        assert (index != null);
        CollectionSerializer collectionSerializer = (CollectionSerializer)((AbstractConsentIndexedStorageAction)this.action).getStorageKeysSerializer();
        Assert.assertNotNull((Object)collectionSerializer);
        return collectionSerializer.deserialize(0L, "context", "_index", index.getValue(), index.getExpiration());
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableStorageIndexKeyStrategy() throws Exception {
        this.action.initialize();
        ((AbstractConsentIndexedStorageAction)this.action).setStorageIndexKeyLookupStrategy((Function)this.nullObj);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableStorageKeysSerializerStrategy() throws Exception {
        this.action.initialize();
        ((AbstractConsentIndexedStorageAction)this.action).setStorageKeysSerializer((StorageSerializer)this.nullObj);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableStorageKeysStrategy() throws Exception {
        this.action.initialize();
        ((AbstractConsentIndexedStorageAction)this.action).setStorageKeysStrategy((Function)this.nullObj);
    }
}

