/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.flow.impl.AbstractConsentActionTest;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentStorageAction;
import net.shibboleth.idp.consent.storage.impl.ConsentSerializer;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.shared.component.UnmodifiableComponentException;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class AbstractConsentStorageActionTest
extends AbstractConsentActionTest {
    private Object nullObj;

    protected void populateAction() throws Exception {
        ((AbstractConsentStorageAction)this.action).setStorageContextLookupStrategy(FunctionSupport.constant((Object)"context"));
        ((AbstractConsentStorageAction)this.action).setStorageKeyLookupStrategy(FunctionSupport.constant((Object)"key"));
    }

    @BeforeMethod
    protected void setUpMemoryStorageService() throws Exception {
        MemoryStorageService storageService = new MemoryStorageService();
        storageService.setId("test");
        storageService.initialize();
        ProfileInterceptorContext pic = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        assert (pic != null);
        ProfileInterceptorFlowDescriptor flow = pic.getAttemptedFlow();
        assert (flow != null);
        flow.setStorageService((StorageService)storageService);
    }

    protected MemoryStorageService getMemoryStorageService() {
        ProfileInterceptorContext pic = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        assert (pic != null);
        ProfileInterceptorFlowDescriptor flow = pic.getAttemptedFlow();
        assert (flow != null);
        Assert.assertNotNull((Object)flow.getStorageService());
        Assert.assertTrue((boolean)(flow.getStorageService() instanceof MemoryStorageService));
        return (MemoryStorageService)flow.getStorageService();
    }

    protected Map<String, Consent> readConsentsFromStorage() throws IOException {
        StorageRecord record = this.getMemoryStorageService().read("context", "key");
        assert (record != null);
        ConsentSerializer consentSerializer = (ConsentSerializer)((AbstractConsentStorageAction)this.action).getStorageSerializer();
        Assert.assertNotNull((Object)consentSerializer);
        return consentSerializer.deserialize(0L, "context", "key", record.getValue(), record.getExpiration());
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableInterceptorContextStrategy() throws Exception {
        this.action.initialize();
        ((AbstractConsentStorageAction)this.action).setStorageContextLookupStrategy((Function)this.nullObj);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableStorageKeyStrategy() throws Exception {
        this.action.initialize();
        ((AbstractConsentStorageAction)this.action).setStorageKeyLookupStrategy((Function)this.nullObj);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableStorageSerializerStrategy() throws Exception {
        this.action.initialize();
        ((AbstractConsentStorageAction)this.action).setStorageSerializer((StorageSerializer)this.nullObj);
    }
}

