/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.impl;

import net.shibboleth.idp.consent.Consent;
import net.shibboleth.shared.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ConsentTest {
    private Consent consent;
    private Object nullObj;

    @BeforeMethod
    public void setUp() {
        this.consent = new Consent();
        this.consent.setId("test");
    }

    @Test
    public void testInstantation() {
        Assert.assertEquals((String)this.consent.getId(), (String)"test");
        Assert.assertNull((Object)this.consent.getValue());
        Assert.assertFalse((boolean)this.consent.isApproved());
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testEmptyValue() {
        this.consent.setValue("");
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullValue() {
        this.consent.setValue((String)this.nullObj);
    }

    @Test
    public void testValue() {
        this.consent.setValue("value");
        Assert.assertEquals((String)this.consent.getValue(), (String)"value");
    }

    @Test
    public void testIsApproved() {
        this.consent.setApproved(true);
        Assert.assertTrue((boolean)this.consent.isApproved());
        this.consent.setApproved(false);
        Assert.assertFalse((boolean)this.consent.isApproved());
    }

    @Test
    public void testEqualityAndHashCode() {
        Assert.assertEquals((Object)this.consent, (Object)this.consent);
        Assert.assertNotEquals((Object)this.consent, null);
        Consent otherConsent = new Consent();
        Assert.assertNotEquals((Object)this.consent, (Object)otherConsent);
        Assert.assertFalse((this.consent.hashCode() == otherConsent.hashCode() ? 1 : 0) != 0);
        otherConsent.setId("test");
        Assert.assertEquals((Object)this.consent, (Object)otherConsent);
        Assert.assertTrue((this.consent.hashCode() == otherConsent.hashCode() ? 1 : 0) != 0);
        this.consent.setValue("value");
        Assert.assertNotEquals((Object)this.consent, (Object)otherConsent);
        Assert.assertFalse((this.consent.hashCode() == otherConsent.hashCode() ? 1 : 0) != 0);
        otherConsent.setValue("value");
        Assert.assertEquals((Object)this.consent, (Object)otherConsent);
        Assert.assertTrue((this.consent.hashCode() == otherConsent.hashCode() ? 1 : 0) != 0);
        this.consent.setApproved(true);
        Assert.assertNotEquals((Object)this.consent, (Object)otherConsent);
        Assert.assertFalse((this.consent.hashCode() == otherConsent.hashCode() ? 1 : 0) != 0);
        otherConsent.setApproved(true);
        Assert.assertEquals((Object)this.consent, (Object)otherConsent);
        Assert.assertTrue((this.consent.hashCode() == otherConsent.hashCode() ? 1 : 0) != 0);
    }
}

