/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.storage.impl.ConsentResult;
import net.shibboleth.shared.collection.CollectionSupport;

public class ConsentTestingSupport {
    @Nonnull
    public static Map<String, Consent> newConsentMap() {
        Consent consent1 = new Consent();
        consent1.setId("consent1");
        consent1.setValue("value1");
        Consent consent2 = new Consent();
        consent2.setId("consent2");
        consent2.setValue("value2");
        HashMap<String, Consent> map = new HashMap<String, Consent>();
        map.put(consent1.getId(), consent1);
        map.put(consent2.getId(), consent2);
        return map;
    }

    @Nonnull
    public static final Map<String, IdPAttribute> newAttributeMap() {
        return ConsentTestingSupport.newAttributeMap(MapType.SORTED);
    }

    @Nonnull
    public static final Map<String, IdPAttribute> newAttributeMap(MapType order) {
        StringAttributeValue value1a = new StringAttributeValue("Avalue1");
        StringAttributeValue value1b = new StringAttributeValue("Bvalue1");
        StringAttributeValue value1c = new StringAttributeValue("Cvalue1");
        StringAttributeValue value2 = new StringAttributeValue("value2");
        StringAttributeValue value3 = new StringAttributeValue("value3");
        IdPAttribute attribute1 = new IdPAttribute("attribute1");
        attribute1.setValues(switch (order) {
            default -> List.of(value1a, value1b, value1c);
            case MapType.ORDER1 -> List.of(value1b, value1a, value1c);
            case MapType.ORDER2 -> List.of(value1c, value1a, value1b);
        });
        IdPAttribute attribute2 = new IdPAttribute("attribute2");
        attribute2.setValues(CollectionSupport.listOf((Object)value1a, (Object)value2));
        IdPAttribute attribute3 = new IdPAttribute("attribute3");
        attribute3.setValues(CollectionSupport.singletonList((Object)value3));
        HashMap<String, IdPAttribute> map = new HashMap<String, IdPAttribute>();
        map.put(attribute1.getId(), attribute1);
        map.put(attribute2.getId(), attribute2);
        map.put(attribute3.getId(), attribute3);
        return map;
    }

    @Nonnull
    public static final List<ConsentResult> newConsentResults() {
        ArrayList<ConsentResult> consentResults = new ArrayList<ConsentResult>();
        consentResults.add(new ConsentResult("context1", "key1", "value1", null));
        consentResults.add(new ConsentResult("context2", "key1", "value1", null));
        consentResults.add(new ConsentResult("context2", "key2", "value2", null));
        return consentResults;
    }

    @Nonnull
    public static Map<String, Integer> newSymbolicsMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("consent1", 101);
        map.put("consent2", 102);
        map.put("attribute1", 201);
        map.put("attribute2", 202);
        map.put("attribute3", 203);
        return map;
    }

    public static enum MapType {
        SORTED,
        ORDER1,
        ORDER2;

    }
}

