/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.consent.logic.impl.AttributeDisplayDescriptionFunction;
import net.shibboleth.idp.consent.logic.impl.AttributeDisplayNameFunction;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceableComponent;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AttributeDisplayNameDescriptionFunctionTest {
    private IdPAttribute testAttribute;
    private MockService service = new MockService();
    private final Map<Locale, String> names = new HashMap<Locale, String>(3);
    private final Map<Locale, String> descriptions = new HashMap<Locale, String>(3);

    @BeforeClass
    public void constructAttribute() {
        IdPAttribute attr = new IdPAttribute("What");
        this.names.put(new Locale("en"), "EN locale Name");
        this.names.put(new Locale("fr"), "FR locale Name");
        this.names.put(new Locale("de"), "DE locale Name");
        this.descriptions.put(new Locale("en"), "EN locale Description");
        this.descriptions.put(new Locale("fr"), "FR locale Description");
        this.descriptions.put(new Locale("de"), "DE locale Description");
        this.testAttribute = attr;
    }

    private HttpServletRequest getMockRequest(String ... languages) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        ArrayList<Locale> locales = new ArrayList<Locale>(languages.length);
        for (String language : languages) {
            locales.add(new Locale(language));
        }
        request.setPreferredLocales(locales);
        return request;
    }

    @Test
    public void testNameHttpOnly() {
        AttributeDisplayNameFunction func = new AttributeDisplayNameFunction(this.getMockRequest("fr", "de", "en"), null, (ReloadableService)this.service);
        Assert.assertEquals((String)((String)func.apply(this.testAttribute)), (String)"FR locale Name");
        func = new AttributeDisplayNameFunction(this.getMockRequest("pt", "es"), null, (ReloadableService)this.service);
        Assert.assertEquals((String)((String)func.apply(this.testAttribute)), (String)this.testAttribute.getId());
    }

    @Test
    public void testNameWithDefault() {
        List<String> fallback = List.of("en", "fr", "de");
        AttributeDisplayNameFunction func = new AttributeDisplayNameFunction(this.getMockRequest("fr", "de", "en"), fallback, (ReloadableService)this.service);
        Assert.assertEquals((String)((String)func.apply(this.testAttribute)), (String)"FR locale Name");
        func = new AttributeDisplayNameFunction(this.getMockRequest("pt", "es"), fallback, (ReloadableService)this.service);
        Assert.assertEquals((String)((String)func.apply(this.testAttribute)), (String)"EN locale Name");
    }

    @Test
    public void testDescHttpOnly() {
        AttributeDisplayDescriptionFunction func = new AttributeDisplayDescriptionFunction(this.getMockRequest("fr", "de", "en"), null, (ReloadableService)this.service);
        Assert.assertEquals((String)((String)func.apply(this.testAttribute)), (String)"FR locale Description");
        func = new AttributeDisplayDescriptionFunction(this.getMockRequest("pt", "es"), null, (ReloadableService)this.service);
        Assert.assertEquals((String)((String)func.apply(this.testAttribute)), (String)this.testAttribute.getId());
    }

    @Test
    public void testDescWithDefault() {
        List<String> fallback = List.of("en", "fr", "de");
        AttributeDisplayDescriptionFunction func = new AttributeDisplayDescriptionFunction(this.getMockRequest("fr", "de", "en"), fallback, (ReloadableService)this.service);
        Assert.assertEquals((String)((String)func.apply(this.testAttribute)), (String)"FR locale Description");
        func = new AttributeDisplayDescriptionFunction(this.getMockRequest("pt", "es"), fallback, (ReloadableService)this.service);
        Assert.assertEquals((String)((String)func.apply(this.testAttribute)), (String)"EN locale Description");
    }

    @Test
    public void testNullFallbackLanguage() {
        ArrayList<String> fallback = new ArrayList<String>(2);
        fallback.add(null);
        fallback.add("");
        fallback.add("fr");
        AttributeDisplayNameFunction displayNameFunc = new AttributeDisplayNameFunction(this.getMockRequest("pt", "es"), fallback, (ReloadableService)this.service);
        Assert.assertEquals((String)((String)displayNameFunc.apply(this.testAttribute)), (String)"FR locale Name");
        AttributeDisplayDescriptionFunction descFunc = new AttributeDisplayDescriptionFunction(this.getMockRequest("pt", "es"), fallback, (ReloadableService)this.service);
        Assert.assertEquals((String)((String)descFunc.apply(this.testAttribute)), (String)"FR locale Description");
    }

    private final class MockService
    implements ReloadableService<AttributeTranscoderRegistry>,
    ServiceableComponent<AttributeTranscoderRegistry>,
    AttributeTranscoderRegistry {
        private MockService() {
        }

        public boolean isInitialized() {
            return true;
        }

        public void initialize() throws ComponentInitializationException {
        }

        public Instant getLastSuccessfulReloadInstant() {
            return null;
        }

        public Instant getLastReloadAttemptInstant() {
            return null;
        }

        public Throwable getReloadFailureCause() {
            return null;
        }

        public void reload() {
        }

        @Nonnull
        public ServiceableComponent<AttributeTranscoderRegistry> getServiceableComponent() {
            return this;
        }

        public String getId() {
            return null;
        }

        @Nonnull
        public Map<Locale, String> getDisplayNames(@Nonnull IdPAttribute attribute) {
            return AttributeDisplayNameDescriptionFunctionTest.this.names;
        }

        @Nonnull
        public Map<Locale, String> getDescriptions(@Nonnull IdPAttribute attribute) {
            return AttributeDisplayNameDescriptionFunctionTest.this.descriptions;
        }

        @Nonnull
        public Collection<TranscodingRule> getTranscodingRules(@Nonnull IdPAttribute from, @Nonnull Class<?> to) {
            return CollectionSupport.emptyList();
        }

        @Nonnull
        public <T> Collection<TranscodingRule> getTranscodingRules(@Nonnull T from) {
            return CollectionSupport.emptyList();
        }

        @Nonnull
        public AttributeTranscoderRegistry getComponent() {
            return this;
        }

        public void close() {
        }
    }
}

