/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.HashMap;
import java.util.Map;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.AttributeReleaseContext;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.idp.consent.flow.ar.impl.AttributeReleaseFlowDescriptor;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.idp.consent.impl.ConsentTestingSupport;
import net.shibboleth.idp.consent.logic.impl.AttributeReleaseConsentFunction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeReleaseConsentFunctionTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private AttributeReleaseFlowDescriptor flowDescriptor;
    private AttributeReleaseConsentFunction function;

    @BeforeMethod
    public void setUp() throws Exception {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.function = new AttributeReleaseConsentFunction();
    }

    private void setUpDescriptor(boolean compareValues) {
        this.flowDescriptor = new AttributeReleaseFlowDescriptor();
        this.flowDescriptor.setId("test");
        this.flowDescriptor.setCompareValues(compareValues);
        ProfileInterceptorContext pic = new ProfileInterceptorContext();
        pic.setAttemptedFlow((ProfileInterceptorFlowDescriptor)this.flowDescriptor);
        this.prc.addSubcontext((BaseContext)pic);
        ProfileInterceptorContext pic2 = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        assert (pic2 != null);
        ProfileInterceptorFlowDescriptor flow = pic2.getAttemptedFlow();
        assert (flow != null);
        Assert.assertTrue((boolean)(flow instanceof ConsentFlowDescriptor));
        Assert.assertEquals((boolean)((ConsentFlowDescriptor)flow).compareValues(), (boolean)compareValues);
    }

    @Test
    public void testNullInput() {
        Assert.assertNull((Object)this.function.apply(null));
    }

    @Test
    public void testNullConsentContext() {
        Assert.assertNull((Object)this.prc.getSubcontext(ConsentContext.class));
        this.setUpDescriptor(false);
        Assert.assertNull((Object)this.function.apply(this.prc));
    }

    @Test
    public void testNullConsentFlowDescriptor() {
        this.prc.addSubcontext((BaseContext)new ConsentContext());
        this.prc.addSubcontext((BaseContext)new ProfileInterceptorContext());
        ProfileInterceptorContext pic2 = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        assert (pic2 != null);
        ProfileInterceptorFlowDescriptor flow = pic2.getAttemptedFlow();
        assert (flow == null);
        Assert.assertNull((Object)this.function.apply(this.prc));
    }

    @Test
    public void testNullAttributeReleaseContext() {
        this.prc.addSubcontext((BaseContext)new ConsentContext());
        this.setUpDescriptor(false);
        Assert.assertNull((Object)this.prc.getSubcontext(AttributeReleaseContext.class));
        Assert.assertNull((Object)this.function.apply(this.prc));
    }

    @Test
    public void testNoConsentableAttributes() {
        this.prc.addSubcontext((BaseContext)new ConsentContext());
        this.prc.addSubcontext((BaseContext)new AttributeReleaseContext(), true);
        this.setUpDescriptor(false);
        AttributeReleaseContext arc = (AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class);
        assert (arc != null);
        Assert.assertTrue((boolean)arc.getConsentableAttributes().isEmpty());
        Map res = this.function.apply(this.prc);
        assert (res != null);
        Assert.assertTrue((boolean)res.isEmpty());
    }

    @Test
    public void testNoPreviousConsents() {
        this.prc.addSubcontext((BaseContext)new ConsentContext());
        AttributeReleaseContext arc = new AttributeReleaseContext();
        arc.getConsentableAttributes().putAll(ConsentTestingSupport.newAttributeMap());
        this.prc.addSubcontext((BaseContext)arc);
        this.setUpDescriptor(false);
        AttributeReleaseContext arc2 = (AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class);
        assert (arc2 != null);
        Assert.assertFalse((boolean)arc2.getConsentableAttributes().isEmpty());
        ConsentContext consentContext = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        assert (consentContext != null);
        Assert.assertTrue((boolean)consentContext.getPreviousConsents().isEmpty());
        HashMap<String, Consent> expected = new HashMap<String, Consent>();
        for (IdPAttribute attr : ConsentTestingSupport.newAttributeMap().values()) {
            Consent consent = new Consent();
            consent.setId(attr.getId());
            expected.put(consent.getId(), consent);
        }
        Assert.assertEquals((Map)this.function.apply(this.prc), expected);
    }

    @Test
    public void testNoPreviousConsentsCompareValues() {
        this.prc.addSubcontext((BaseContext)new ConsentContext());
        AttributeReleaseContext arc = new AttributeReleaseContext();
        arc.getConsentableAttributes().putAll(ConsentTestingSupport.newAttributeMap());
        this.prc.addSubcontext((BaseContext)arc);
        this.setUpDescriptor(true);
        AttributeReleaseContext arc2 = (AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class);
        assert (arc2 != null);
        Assert.assertFalse((boolean)arc2.getConsentableAttributes().isEmpty());
        ConsentContext consentContext = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        assert (consentContext != null);
        Assert.assertTrue((boolean)consentContext.getPreviousConsents().isEmpty());
        HashMap<String, Consent> expected = new HashMap<String, Consent>();
        for (IdPAttribute attr : ConsentTestingSupport.newAttributeMap().values()) {
            Consent consent = new Consent();
            consent.setId(attr.getId());
            consent.setValue((String)this.flowDescriptor.getAttributeValuesHashFunction().apply(attr.getValues()));
            expected.put(consent.getId(), consent);
        }
        Assert.assertEquals((Map)this.function.apply(this.prc), expected);
    }

    @Test
    public void testRememberPreviousConsents() {
        Consent previousConsent = new Consent();
        previousConsent.setId("attribute1");
        previousConsent.setApproved(true);
        ConsentContext consentCtx = new ConsentContext();
        consentCtx.getPreviousConsents().put(previousConsent.getId(), previousConsent);
        this.prc.addSubcontext((BaseContext)consentCtx);
        AttributeReleaseContext arc = new AttributeReleaseContext();
        arc.getConsentableAttributes().putAll(ConsentTestingSupport.newAttributeMap());
        this.prc.addSubcontext((BaseContext)arc);
        this.setUpDescriptor(false);
        AttributeReleaseContext arc2 = (AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class);
        assert (arc2 != null);
        Assert.assertFalse((boolean)arc2.getConsentableAttributes().isEmpty());
        ConsentContext consentContext = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        assert (consentContext != null);
        Assert.assertFalse((boolean)consentContext.getPreviousConsents().isEmpty());
        HashMap<String, Consent> expected = new HashMap<String, Consent>();
        for (IdPAttribute attr : ConsentTestingSupport.newAttributeMap().values()) {
            Consent consent = new Consent();
            consent.setId(attr.getId());
            if (attr.getId().equals("attribute1")) {
                consent.setApproved(true);
            }
            expected.put(consent.getId(), consent);
        }
        Assert.assertEquals((Map)this.function.apply(this.prc), expected);
    }

    @Test
    public void testRememberPreviousConsentsCompareValues() {
        Consent previousConsent = new Consent();
        previousConsent.setId("attribute1");
        previousConsent.setValue((String)this.flowDescriptor.getAttributeValuesHashFunction().apply(ConsentTestingSupport.newAttributeMap().get("attribute1").getValues()));
        previousConsent.setApproved(true);
        ConsentContext consentCtx = new ConsentContext();
        consentCtx.getPreviousConsents().put(previousConsent.getId(), previousConsent);
        this.prc.addSubcontext((BaseContext)consentCtx);
        AttributeReleaseContext arc = new AttributeReleaseContext();
        arc.getConsentableAttributes().putAll(ConsentTestingSupport.newAttributeMap());
        this.prc.addSubcontext((BaseContext)arc);
        this.setUpDescriptor(true);
        AttributeReleaseContext arc2 = (AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class);
        assert (arc2 != null);
        Assert.assertFalse((boolean)arc2.getConsentableAttributes().isEmpty());
        ConsentContext consentContext = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        assert (consentContext != null);
        Assert.assertFalse((boolean)consentContext.getPreviousConsents().isEmpty());
        HashMap<String, Consent> expected = new HashMap<String, Consent>();
        for (IdPAttribute attr : ConsentTestingSupport.newAttributeMap().values()) {
            Consent consent = new Consent();
            consent.setId(attr.getId());
            consent.setValue((String)this.flowDescriptor.getAttributeValuesHashFunction().apply(attr.getValues()));
            if (attr.getId().equals("attribute1")) {
                consent.setApproved(true);
            }
            expected.put(consent.getId(), consent);
        }
        Assert.assertEquals((Map)this.function.apply(this.prc), expected);
    }

    @Test
    public void testSorting() throws Exception {
        Consent previousConsent = new Consent();
        previousConsent.setId("attribute1");
        previousConsent.setValue((String)this.flowDescriptor.getAttributeValuesHashFunction().apply(ConsentTestingSupport.newAttributeMap(ConsentTestingSupport.MapType.ORDER1).get("attribute1").getValues()));
        previousConsent.setApproved(true);
        ConsentContext consentCtx = new ConsentContext();
        consentCtx.getPreviousConsents().put(previousConsent.getId(), previousConsent);
        this.prc.addSubcontext((BaseContext)consentCtx);
        AttributeReleaseContext arc = new AttributeReleaseContext();
        arc.getConsentableAttributes().putAll(ConsentTestingSupport.newAttributeMap(ConsentTestingSupport.MapType.ORDER1));
        this.prc.addSubcontext((BaseContext)arc);
        this.setUpDescriptor(true);
        Map firstResult = this.function.apply(this.prc);
        assert (firstResult != null);
        Consent firstConsent = (Consent)firstResult.get("attribute1");
        Assert.assertTrue((boolean)firstConsent.isApproved());
        this.setUp();
        consentCtx = new ConsentContext();
        consentCtx.getPreviousConsents().put(firstConsent.getId(), firstConsent);
        this.prc.addSubcontext((BaseContext)consentCtx);
        arc = new AttributeReleaseContext();
        arc.getConsentableAttributes().putAll(ConsentTestingSupport.newAttributeMap(ConsentTestingSupport.MapType.ORDER2));
        this.prc.addSubcontext((BaseContext)arc);
        this.setUpDescriptor(true);
        Map secondResult = this.function.apply(this.prc);
        assert (secondResult != null);
        Consent secondConsent = (Consent)secondResult.get("attribute1");
        Assert.assertTrue((boolean)secondConsent.isApproved());
    }

    @Test
    public void testRememberPreviousConsentsDifferentValueCompareValues() {
        Consent previousConsent = new Consent();
        previousConsent.setId("attribute1");
        previousConsent.setValue("differentValue");
        previousConsent.setApproved(true);
        ConsentContext consentCtx = new ConsentContext();
        consentCtx.getPreviousConsents().put(previousConsent.getId(), previousConsent);
        this.prc.addSubcontext((BaseContext)consentCtx);
        AttributeReleaseContext arc = new AttributeReleaseContext();
        arc.getConsentableAttributes().putAll(ConsentTestingSupport.newAttributeMap());
        this.prc.addSubcontext((BaseContext)arc);
        this.setUpDescriptor(true);
        AttributeReleaseContext arc2 = (AttributeReleaseContext)this.prc.getSubcontext(AttributeReleaseContext.class);
        assert (arc2 != null);
        Assert.assertFalse((boolean)arc2.getConsentableAttributes().isEmpty());
        ConsentContext consentContext = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        assert (consentContext != null);
        Assert.assertFalse((boolean)consentContext.getPreviousConsents().isEmpty());
        HashMap<String, Consent> expected = new HashMap<String, Consent>();
        for (IdPAttribute attr : ConsentTestingSupport.newAttributeMap().values()) {
            Consent consent = new Consent();
            consent.setId(attr.getId());
            consent.setValue((String)this.flowDescriptor.getAttributeValuesHashFunction().apply(attr.getValues()));
            expected.put(consent.getId(), consent);
        }
        Assert.assertEquals((Map)this.function.apply(this.prc), expected);
    }
}

