/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.Collection;
import java.util.Map;
import net.shibboleth.idp.attribute.ByteAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.consent.impl.ConsentTestingSupport;
import net.shibboleth.idp.consent.logic.impl.AttributeValueLookupFunction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.ConstraintViolationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeValueLookupFunctionTest {
    private AttributeValueLookupFunction function;
    private RequestContext src;
    private ProfileRequestContext prc;
    private String nullObj;

    @BeforeMethod
    public void setUp() throws Exception {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        AttributeContext attributeCtx = new AttributeContext();
        Map<String, IdPAttribute> attributes = ConsentTestingSupport.newAttributeMap();
        attributeCtx.setIdPAttributes(attributes.values());
        Map<String, IdPAttribute> unfilteredAttributes = ConsentTestingSupport.newAttributeMap();
        IdPAttribute attribute4 = new IdPAttribute("attribute4");
        attribute4.setValues(CollectionSupport.singletonList((Object)new StringAttributeValue("value4")));
        unfilteredAttributes.put(attribute4.getId(), attribute4);
        attributeCtx.setUnfilteredIdPAttributes(unfilteredAttributes.values());
        ((RelyingPartyContext)this.prc.ensureSubcontext(RelyingPartyContext.class)).addSubcontext((BaseContext)attributeCtx);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testEmptyConstructor() {
        this.function = new AttributeValueLookupFunction("");
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullConstructor() {
        this.function = new AttributeValueLookupFunction(this.nullObj);
    }

    @Test
    public void testNullProfileRequestContext() {
        this.function = new AttributeValueLookupFunction("foo");
        Assert.assertNull((Object)this.function.apply(null));
    }

    @Test
    public void testAttributeValue() {
        this.function = new AttributeValueLookupFunction("attribute1");
        Assert.assertEquals((String)this.function.apply(this.prc), (String)"Avalue1");
    }

    @Test
    public void testAttributeNotFound() {
        this.function = new AttributeValueLookupFunction("notFound");
        Assert.assertNull((Object)this.function.apply(this.prc));
    }

    @Test
    public void testAttributeWithNoValues() {
        AttributeContext attributeCtx = (AttributeContext)((RelyingPartyContext)this.prc.ensureSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class);
        assert (attributeCtx != null);
        attributeCtx.setIdPAttributes((Collection)CollectionSupport.singleton((Object)new IdPAttribute("EmptyAttribute")));
        this.function = new AttributeValueLookupFunction("EmptyAttribute");
        Assert.assertNull((Object)this.function.apply(this.prc));
    }

    @Test
    public void testNonStringAttributeValue() {
        byte[] data = new byte[]{1, 2, 3, 15};
        IdPAttribute byteAttribute = new IdPAttribute("ByteAttribute");
        byteAttribute.setValues(CollectionSupport.singletonList((Object)new ByteAttributeValue(data)));
        AttributeContext attributeCtx = (AttributeContext)((RelyingPartyContext)this.prc.ensureSubcontext(RelyingPartyContext.class)).getSubcontext(AttributeContext.class);
        assert (attributeCtx != null);
        attributeCtx.setIdPAttributes((Collection)CollectionSupport.singleton((Object)byteAttribute));
        this.function = new AttributeValueLookupFunction("ByteAttribute");
        Assert.assertNull((Object)this.function.apply(this.prc));
    }

    @Test
    public void testUseFilteredAttributes() {
        this.function = new AttributeValueLookupFunction("attribute4");
        this.function.setUseUnfilteredAttributes(false);
        Assert.assertNull((Object)this.function.apply(this.prc));
    }

    @Test
    public void testUseUnfilteredAttributes() {
        this.function = new AttributeValueLookupFunction("attribute4");
        Assert.assertEquals((String)this.function.apply(this.prc), (String)"value4");
    }
}

