/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.shibboleth.idp.consent.logic.impl.CounterStorageKeyComparator;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CounterStorageKeyComparatorTest {
    private CounterStorageKeyComparator c;
    private List<String> keys;
    private Map<String, Long> map;

    @BeforeMethod
    public void setUp() {
        this.keys = Arrays.asList("key1", "key2", "key3", "key4");
        this.map = new LinkedHashMap<String, Long>();
        assert (this.keys != null);
        this.c = new CounterStorageKeyComparator(this.keys, this.map);
    }

    @Test
    public void testNoCounters() {
        Collections.sort(this.keys, this.c);
        Assert.assertEquals(this.keys, Arrays.asList("key1", "key2", "key3", "key4"));
    }

    @Test
    public void testSameCounters() {
        this.map.put("key1", 1L);
        this.map.put("key2", 1L);
        this.map.put("key3", 1L);
        this.map.put("key4", 1L);
        Collections.sort(this.keys, this.c);
        Assert.assertEquals(this.keys, Arrays.asList("key1", "key2", "key3", "key4"));
    }

    @Test
    public void testDifferentCounters() {
        this.map.put("key1", 4L);
        this.map.put("key2", 2L);
        this.map.put("key3", 1L);
        this.map.put("key4", 3L);
        Collections.sort(this.keys, this.c);
        Assert.assertEquals(this.keys, Arrays.asList("key3", "key2", "key4", "key1"));
    }

    @Test
    public void testSomeSameCounters1() {
        this.map.put("key1", 2L);
        this.map.put("key2", 2L);
        this.map.put("key3", 1L);
        this.map.put("key4", 1L);
        Collections.sort(this.keys, this.c);
        Assert.assertEquals(this.keys, Arrays.asList("key3", "key4", "key1", "key2"));
    }

    @Test
    public void testSomeSameCounters2() {
        this.map.put("key1", 2L);
        this.map.put("key2", 1L);
        this.map.put("key3", 2L);
        this.map.put("key4", 1L);
        Collections.sort(this.keys, this.c);
        Assert.assertEquals(this.keys, Arrays.asList("key2", "key4", "key1", "key3"));
    }

    @Test
    public void testMissingCounters1() {
        this.map.put("key1", 1L);
        this.map.put("key3", 1L);
        this.map.put("key4", 1L);
        Collections.sort(this.keys, this.c);
        Assert.assertEquals(this.keys, Arrays.asList("key2", "key1", "key3", "key4"));
    }

    @Test
    public void testMissingCounters2() {
        this.map.put("key1", 2L);
        this.map.put("key3", 1L);
        this.map.put("key4", 1L);
        Collections.sort(this.keys, this.c);
        Assert.assertEquals(this.keys, Arrays.asList("key2", "key3", "key4", "key1"));
    }
}

