/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.idp.consent.logic.impl.CounterStorageKeyFunction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.UnmodifiableComponentException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CounterStorageKeyFunctionTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private ProfileInterceptorContext pic;
    private ConsentFlowDescriptor descriptor;
    private MemoryStorageService storageService;
    private List<String> keys;
    private Pair<ProfileRequestContext, List<String>> input;
    private CounterStorageKeyFunction f;
    private Object nullObj;

    protected void createCounter(@Nonnull String key, int iterations) throws IOException, InterruptedException {
        String counterKey = key + ":_counter";
        this.storageService.create("mockFlow", counterKey, Long.toString(System.currentTimeMillis()), null);
        for (int i = 1; i < iterations; ++i) {
            this.storageService.update("mockFlow", counterKey, Long.toString(System.currentTimeMillis()), null);
            Thread.sleep(1L);
        }
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        SpringRequestContext springRequestContext = new SpringRequestContext();
        springRequestContext.setRequestContext(this.src);
        this.prc.addSubcontext((BaseContext)springRequestContext);
        MemoryStorageService service = this.storageService = new MemoryStorageService();
        service.setId("test");
        service.initialize();
        this.descriptor = new ConsentFlowDescriptor();
        this.descriptor.setId("test");
        this.pic = new ProfileInterceptorContext();
        this.pic.setAttemptedFlow((ProfileInterceptorFlowDescriptor)this.descriptor);
        ProfileInterceptorFlowDescriptor flow = this.pic.getAttemptedFlow();
        assert (flow != null);
        flow.setStorageService((StorageService)service);
        assert (this.pic != null);
        this.prc.addSubcontext((BaseContext)this.pic);
        this.keys = Arrays.asList("key1", "key2", "key3", "key4");
        this.input = new Pair((Object)this.prc, this.keys);
        this.f = new CounterStorageKeyFunction();
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableInterceptorContextStrategy() throws Exception {
        this.f.initialize();
        this.f.setInterceptorContextLookupStrategy((Function)this.nullObj);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testUnmodifiableStorageContextStrategy() throws Exception {
        this.f.initialize();
        this.f.setStorageContextLookupStrategy((Function)this.nullObj);
    }

    @Test
    public void testNullPairInput() throws Exception {
        this.f.initialize();
        List sortedKeys = this.f.apply(null);
        Assert.assertNull((Object)sortedKeys);
    }

    @Test
    public void testNullProfileRequestContextInput() throws Exception {
        this.f.initialize();
        List sortedKeys = this.f.apply(new Pair(null, this.keys));
        Assert.assertNull((Object)sortedKeys);
    }

    @Test
    public void testNullKeysInput() throws Exception {
        this.f.initialize();
        List sortedKeys = this.f.apply(new Pair((Object)this.prc, null));
        Assert.assertNull((Object)sortedKeys);
    }

    @Test
    public void testNoProfileInterceptorContext() throws Exception {
        this.prc.removeSubcontext(ProfileInterceptorContext.class);
        this.f.initialize();
        List sortedKeys = this.f.apply(this.input);
        Assert.assertNotNull((Object)sortedKeys);
        Assert.assertEquals(this.keys, Arrays.asList("key1", "key2", "key3", "key4"));
    }

    @Test
    public void testNoFlowDescriptor() throws Exception {
        this.pic = new ProfileInterceptorContext();
        this.prc.addSubcontext((BaseContext)this.pic, true);
        this.f.initialize();
        List sortedKeys = this.f.apply(this.input);
        Assert.assertNotNull((Object)sortedKeys);
        Assert.assertEquals(this.keys, Arrays.asList("key1", "key2", "key3", "key4"));
    }

    @Test
    public void testNoStorageService() throws Exception {
        this.pic = new ProfileInterceptorContext();
        this.pic.setAttemptedFlow((ProfileInterceptorFlowDescriptor)this.descriptor);
        assert (this.pic != null);
        this.prc.addSubcontext((BaseContext)this.pic, true);
        this.f.initialize();
        List sortedKeys = this.f.apply(this.input);
        Assert.assertNotNull((Object)sortedKeys);
        Assert.assertEquals(this.keys, Arrays.asList("key1", "key2", "key3", "key4"));
    }

    @Test
    public void testNoStorageContext() throws Exception {
        this.prc.removeSubcontext(SpringRequestContext.class);
        this.f.initialize();
        List sortedKeys = this.f.apply(this.input);
        Assert.assertNotNull((Object)sortedKeys);
        Assert.assertEquals(this.keys, Arrays.asList("key1", "key2", "key3", "key4"));
    }

    @Test
    public void testNoCounters() throws Exception {
        this.f.initialize();
        List sortedKeys = this.f.apply(this.input);
        Assert.assertNotNull((Object)sortedKeys);
        Assert.assertEquals(this.keys, Arrays.asList("key1", "key2", "key3", "key4"));
    }

    @Test
    public void testSameOrderCounters() throws Exception {
        this.createCounter("key1", 1);
        this.createCounter("key2", 1);
        this.createCounter("key3", 1);
        this.createCounter("key4", 1);
        this.f.initialize();
        List sortedKeys = this.f.apply(this.input);
        Assert.assertNotNull((Object)sortedKeys);
        Assert.assertEquals(this.keys, Arrays.asList("key1", "key2", "key3", "key4"));
    }

    @Test
    public void testDifferentOrderCounters() throws Exception {
        this.createCounter("key1", 4);
        this.createCounter("key2", 2);
        this.createCounter("key3", 1);
        this.createCounter("key4", 3);
        this.f.initialize();
        List sortedKeys = this.f.apply(this.input);
        Assert.assertNotNull((Object)sortedKeys);
        Assert.assertEquals(this.keys, Arrays.asList("key3", "key2", "key4", "key1"));
    }

    @Test
    public void testMissingCounters() throws Exception {
        this.createCounter("key1", 4);
        this.createCounter("key3", 1);
        this.createCounter("key4", 3);
        this.f.initialize();
        List sortedKeys = this.f.apply(this.input);
        Assert.assertNotNull((Object)sortedKeys);
        Assert.assertEquals(this.keys, Arrays.asList("key2", "key3", "key4", "key1"));
    }
}

