/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import net.shibboleth.idp.consent.logic.impl.FlowIdLookupFunction;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FlowIdLookupFunctionTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private FlowIdLookupFunction function;

    @BeforeMethod
    public void setUp() throws Exception {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.function = new FlowIdLookupFunction();
    }

    @Test
    public void testNullInput() {
        Assert.assertNull((Object)this.function.apply(null));
    }

    @Test
    public void testNullSpringRequestContext() {
        Assert.assertNull((Object)this.prc.getSubcontext(SpringRequestContext.class));
        Assert.assertNull((Object)this.function.apply(this.prc));
    }

    @Test
    public void testNullWebFlowRequestContext() {
        this.prc.ensureSubcontext(SpringRequestContext.class);
        SpringRequestContext context = (SpringRequestContext)this.prc.getSubcontext(SpringRequestContext.class);
        assert (context != null);
        Assert.assertNull((Object)context.getRequestContext());
        Assert.assertNull((Object)this.function.apply(this.prc));
    }

    @Test(enabled=false)
    public void testNullFlowExecutionContext() {
    }

    @Test(enabled=false)
    public void testNonActiveFlowExecutionContext() {
    }

    @Test
    public void testFlowId() {
        SpringRequestContext context = (SpringRequestContext)this.prc.ensureSubcontext(SpringRequestContext.class);
        assert (context != null);
        context.setRequestContext(this.src);
        SpringRequestContext ctx2 = (SpringRequestContext)this.prc.getSubcontext(SpringRequestContext.class);
        assert (ctx2 != null);
        Assert.assertNotNull((Object)ctx2.getRequestContext());
        Assert.assertEquals((String)this.function.apply(this.prc), (String)"mockFlow");
    }
}

