/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.Map;
import java.util.Objects;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.idp.consent.impl.ConsentTestingSupport;
import net.shibboleth.idp.consent.logic.impl.IsConsentRequiredPredicate;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class IsConsentRequiredPredicateTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private IsConsentRequiredPredicate p;

    @BeforeMethod
    public void setUp() throws Exception {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.p = new IsConsentRequiredPredicate();
    }

    private void setUpDescriptor(boolean compareValues) {
        ConsentFlowDescriptor descriptor = new ConsentFlowDescriptor();
        descriptor.setId("test");
        descriptor.setCompareValues(compareValues);
        ProfileInterceptorContext pic = new ProfileInterceptorContext();
        pic.setAttemptedFlow((ProfileInterceptorFlowDescriptor)descriptor);
        this.prc.addSubcontext((BaseContext)pic);
        ProfileInterceptorContext pic2 = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        assert (pic2 != null);
        ProfileInterceptorFlowDescriptor flow = pic2.getAttemptedFlow();
        assert (flow != null);
        Assert.assertTrue((boolean)(flow instanceof ConsentFlowDescriptor));
        Assert.assertEquals((boolean)((ConsentFlowDescriptor)flow).compareValues(), (boolean)compareValues);
    }

    private void setUpMatchingPreviousAndCurrentConsents() {
        ConsentContext consentCtx = new ConsentContext();
        consentCtx.getPreviousConsents().putAll(ConsentTestingSupport.newConsentMap());
        consentCtx.getCurrentConsents().putAll(ConsentTestingSupport.newConsentMap());
        this.prc.addSubcontext((BaseContext)consentCtx);
        ConsentContext ctx2 = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        assert (ctx2 != null);
        Assert.assertFalse((boolean)ctx2.getPreviousConsents().isEmpty());
        Assert.assertFalse((boolean)ctx2.getCurrentConsents().isEmpty());
        Assert.assertTrue((boolean)Objects.equals(ctx2.getPreviousConsents(), ctx2.getCurrentConsents()));
    }

    private void setUpInPreviousButNotCurrentConsents() {
        ConsentContext consentCtx = new ConsentContext();
        consentCtx.getPreviousConsents().putAll(ConsentTestingSupport.newConsentMap());
        Map<String, Consent> consentSubset = ConsentTestingSupport.newConsentMap();
        consentSubset.remove("consent1");
        consentCtx.getCurrentConsents().putAll(consentSubset);
        this.prc.addSubcontext((BaseContext)consentCtx);
        ConsentContext ctx2 = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        assert (ctx2 != null);
        Assert.assertFalse((boolean)ctx2.getPreviousConsents().isEmpty());
        Assert.assertFalse((boolean)ctx2.getCurrentConsents().isEmpty());
        Assert.assertFalse((boolean)Objects.equals(ctx2.getPreviousConsents(), ctx2.getCurrentConsents()));
        Assert.assertFalse((boolean)Objects.equals(ctx2.getPreviousConsents().keySet(), ctx2.getCurrentConsents().keySet()));
    }

    private void setUpInCurrentButNotPreviousConsents() {
        ConsentContext consentCtx = new ConsentContext();
        consentCtx.getCurrentConsents().putAll(ConsentTestingSupport.newConsentMap());
        Map<String, Consent> consentSubset = ConsentTestingSupport.newConsentMap();
        consentSubset.remove("consent1");
        consentCtx.getPreviousConsents().putAll(consentSubset);
        this.prc.addSubcontext((BaseContext)consentCtx);
        ConsentContext ctx2 = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        assert (ctx2 != null);
        Assert.assertFalse((boolean)ctx2.getPreviousConsents().isEmpty());
        Assert.assertFalse((boolean)ctx2.getCurrentConsents().isEmpty());
        Assert.assertFalse((boolean)Objects.equals(ctx2.getPreviousConsents(), ctx2.getCurrentConsents()));
    }

    private void setUpInPreviousAndCurrentConsentsWithDifferentValue() {
        ConsentContext consentCtx = new ConsentContext();
        consentCtx.getPreviousConsents().putAll(ConsentTestingSupport.newConsentMap());
        Map<String, Consent> consentSubset = ConsentTestingSupport.newConsentMap();
        consentSubset.get("consent1").setValue("differentValue");
        consentCtx.getCurrentConsents().putAll(consentSubset);
        this.prc.addSubcontext((BaseContext)consentCtx);
        ConsentContext ctx2 = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        assert (ctx2 != null);
        Assert.assertFalse((boolean)ctx2.getPreviousConsents().isEmpty());
        Assert.assertFalse((boolean)ctx2.getCurrentConsents().isEmpty());
        Assert.assertFalse((boolean)Objects.equals(ctx2.getPreviousConsents(), ctx2.getCurrentConsents()));
        Assert.assertTrue((boolean)Objects.equals(ctx2.getPreviousConsents().keySet(), ctx2.getCurrentConsents().keySet()));
    }

    @Test
    public void testNullInput() {
        Assert.assertFalse((boolean)this.p.test(null));
    }

    @Test
    public void testNullConsentContext() {
        Assert.assertNull((Object)this.prc.getSubcontext(ConsentContext.class));
        Assert.assertFalse((boolean)this.p.test(this.prc));
    }

    @Test
    public void testNullConsentFlowDescriptor() {
        this.prc.addSubcontext((BaseContext)new ConsentContext());
        Assert.assertNotNull((Object)this.prc.getSubcontext(ConsentContext.class));
        this.prc.addSubcontext((BaseContext)new ProfileInterceptorContext());
        ProfileInterceptorContext pic2 = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        assert (pic2 != null);
        Assert.assertNull((Object)pic2.getAttemptedFlow());
        Assert.assertFalse((boolean)this.p.test(this.prc));
    }

    @Test
    public void testNoPreviousConsents() {
        this.prc.addSubcontext((BaseContext)new ConsentContext());
        ConsentContext ctx2 = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        assert (ctx2 != null);
        Assert.assertTrue((boolean)ctx2.getPreviousConsents().isEmpty());
        ctx2.getCurrentConsents().put("test", new Consent());
        this.setUpDescriptor(false);
        Assert.assertTrue((boolean)this.p.test(this.prc));
    }

    @Test
    public void testNoCurrentConsents() {
        ConsentContext consentCtx = new ConsentContext();
        consentCtx.getPreviousConsents().putAll(ConsentTestingSupport.newConsentMap());
        this.prc.addSubcontext((BaseContext)consentCtx);
        ConsentContext ctx2 = (ConsentContext)this.prc.getSubcontext(ConsentContext.class);
        assert (ctx2 != null);
        Assert.assertFalse((boolean)ctx2.getPreviousConsents().isEmpty());
        Assert.assertTrue((boolean)ctx2.getCurrentConsents().isEmpty());
        this.setUpDescriptor(false);
        Assert.assertFalse((boolean)this.p.test(this.prc));
    }

    @Test
    public void testMatchingPreviousAndCurrentConsents() {
        this.setUpMatchingPreviousAndCurrentConsents();
        this.setUpDescriptor(false);
        Assert.assertFalse((boolean)this.p.test(this.prc));
    }

    @Test
    public void testInPreviousButNotCurrentConsents() {
        this.setUpInPreviousButNotCurrentConsents();
        this.setUpDescriptor(false);
        Assert.assertFalse((boolean)this.p.test(this.prc));
    }

    @Test
    public void testInCurrentButNotPreviousConsents() {
        this.setUpInCurrentButNotPreviousConsents();
        this.setUpDescriptor(false);
        Assert.assertTrue((boolean)this.p.test(this.prc));
    }

    @Test
    public void testMatchingPreviousAndCurrentConsentsCompareValues() {
        this.setUpMatchingPreviousAndCurrentConsents();
        this.setUpDescriptor(true);
        Assert.assertFalse((boolean)this.p.test(this.prc));
    }

    @Test
    public void testInPreviousButNotCurrentConsentsCompareValues() {
        this.setUpInPreviousButNotCurrentConsents();
        this.setUpDescriptor(true);
        Assert.assertFalse((boolean)this.p.test(this.prc));
    }

    @Test
    public void testInCurrentButNotPreviousConsentsCompareValues() {
        this.setUpInCurrentButNotPreviousConsents();
        this.setUpDescriptor(true);
        Assert.assertTrue((boolean)this.p.test(this.prc));
    }

    @Test
    public void testInPreviousAndCurrentConsentsWithDifferentValue() {
        this.setUpInPreviousAndCurrentConsentsWithDifferentValue();
        this.setUpDescriptor(false);
        Assert.assertFalse((boolean)this.p.test(this.prc));
    }

    @Test
    public void testInPreviousAndCurrentConsentsWithDifferentValueCompareValues() {
        this.setUpInPreviousAndCurrentConsentsWithDifferentValue();
        this.setUpDescriptor(true);
        Assert.assertTrue((boolean)this.p.test(this.prc));
    }
}

