/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.flow.impl.ConsentFlowDescriptor;
import net.shibboleth.idp.consent.logic.impl.MessageSourceConsentFunction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.shared.component.UnmodifiableComponentException;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MessageSourceConsentFunctionTest {
    private RequestContext src;
    private ProfileRequestContext prc;
    private MessageSource messageSource;
    private MessageSourceConsentFunction function;
    private Object nullObject;

    @BeforeMethod
    public void setUp() throws Exception {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.messageSource = new MockMessageSource();
        this.function = new MessageSourceConsentFunction();
        assert (this.messageSource != null);
        this.function.setMessageSource(this.messageSource);
    }

    private void setUpDescriptor(boolean compareValues) {
        ConsentFlowDescriptor descriptor = new ConsentFlowDescriptor();
        descriptor.setId("test");
        descriptor.setCompareValues(compareValues);
        ProfileInterceptorContext pic = new ProfileInterceptorContext();
        pic.setAttemptedFlow((ProfileInterceptorFlowDescriptor)descriptor);
        this.prc.addSubcontext((BaseContext)pic);
        ProfileInterceptorContext pic2 = (ProfileInterceptorContext)this.prc.getSubcontext(ProfileInterceptorContext.class);
        assert (pic2 != null);
        ProfileInterceptorFlowDescriptor flow = pic2.getAttemptedFlow();
        assert (flow != null);
        Assert.assertTrue((boolean)(flow instanceof ConsentFlowDescriptor));
        Assert.assertEquals((boolean)((ConsentFlowDescriptor)flow).compareValues(), (boolean)compareValues);
    }

    @Test
    public void testNullInput() {
        Assert.assertNull((Object)this.function.apply(null));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullIdMessageCode() throws Exception {
        this.function.setConsentKeyLookupStrategy((Function)this.nullObject);
        this.function.initialize();
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullValueMessageCode() throws Exception {
        this.function.setConsentValueMessageCodeSuffix((String)this.nullObject);
        this.function.initialize();
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testEmptyValueMessageCode() throws Exception {
        this.function.setConsentValueMessageCodeSuffix("");
        this.function.initialize();
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testInstantiationIdMessageCode() throws Exception {
        this.function.setConsentKeyLookupStrategy(FunctionSupport.constant((Object)"consentIdMessageCode"));
        this.function.initialize();
        this.function.setConsentKeyLookupStrategy(FunctionSupport.constant((Object)"consentIdMessageCode"));
    }

    @Test
    public void testMessageSourceConsent() throws Exception {
        this.setUpDescriptor(false);
        this.function.setConsentKeyLookupStrategy(FunctionSupport.constant((Object)"key"));
        this.function.setLocaleLookupStrategy(e -> new Locale("en"));
        this.function.initialize();
        Consent consent = new Consent();
        consent.setId("id");
        HashMap<String, Consent> expected = new HashMap<String, Consent>();
        expected.put(consent.getId(), consent);
        Assert.assertEquals((Map)this.function.apply(this.prc), expected);
    }

    @Test
    public void testMessageSourceConsentCompareValues() throws Exception {
        this.setUpDescriptor(true);
        this.function.setConsentKeyLookupStrategy(FunctionSupport.constant((Object)"key"));
        this.function.setLocaleLookupStrategy(e -> new Locale("en"));
        this.function.initialize();
        Consent consent = new Consent();
        consent.setId("id");
        consent.setValue((String)this.function.getHashFunction().apply("value"));
        HashMap<String, Consent> expected = new HashMap<String, Consent>();
        expected.put(consent.getId(), consent);
        Assert.assertEquals((Map)this.function.apply(this.prc), expected);
    }

    private class MockMessageSource
    implements MessageSource {
        private MockMessageSource() {
        }

        public String getMessage(@Nonnull String code, @Nullable Object[] args, @Nullable String defaultMessage, @Nonnull Locale locale) {
            if (code.equals("key")) {
                return "id";
            }
            if (code.equals("id.text")) {
                return "value";
            }
            return defaultMessage;
        }

        @Nonnull
        public String getMessage(@Nonnull String code, @Nullable Object[] args, @Nonnull Locale locale) throws NoSuchMessageException {
            if (code.equals("key")) {
                return "id";
            }
            if (code.equals("id.text")) {
                return "value";
            }
            throw new NoSuchMessageException("No such message");
        }

        @Nonnull
        public String getMessage(@Nonnull MessageSourceResolvable resolvable, @Nonnull Locale locale) throws NoSuchMessageException {
            String[] codes = resolvable.getCodes();
            assert (codes != null);
            if (codes[0].equals("key")) {
                return "id";
            }
            if (codes[0].equals("id.text")) {
                return "value";
            }
            throw new NoSuchMessageException("No such message");
        }
    }
}

