/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.storage.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.shibboleth.idp.consent.storage.impl.CollectionSerializer;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CollectionSerializerTest {
    protected CollectionSerializer serializer;
    private Object nullObj;

    @BeforeMethod
    public void setUp() throws Exception {
        this.serializer = new CollectionSerializer();
        this.serializer.initialize();
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNull() throws Exception {
        this.serializer.serialize((Collection)this.nullObj);
    }

    @Test
    public void testEmpty() throws Exception {
        Assert.assertEquals((String)this.serializer.serialize(new ArrayList()), (String)"[]");
        Assert.assertEquals((Collection)this.serializer.deserialize(-1L, "context", "key", "[]", null), (Collection)CollectionSupport.emptyList());
    }

    @Test
    public void testNullValue() throws Exception {
        Assert.assertEquals((String)this.serializer.serialize((Collection)CollectionSupport.singletonList((Object)((String)this.nullObj))), (String)"[]");
        Assert.assertEquals((Collection)this.serializer.deserialize(-1L, "context", "key", "[null]", null), (Collection)CollectionSupport.emptyList());
    }

    @Test
    public void testSimple() throws IOException {
        List collection = CollectionSupport.listOf((Object[])new String[]{"element1", "element2", "element3"});
        String serialized = this.serializer.serialize((Collection)collection);
        Assert.assertEquals((String)serialized, (String)"[\"element1\",\"element2\",\"element3\"]");
        Collection deserialized = this.serializer.deserialize(-1L, "context", "key", serialized, null);
        Assert.assertEquals((Collection)deserialized, (Collection)collection);
    }
}

