/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentStorageAction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

public class ReadConsentFromStorage
extends AbstractConsentStorageAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReadConsentFromStorage.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        String storageContext = this.getStorageContext();
        ConsentContext consentContext = this.getConsentContext();
        String key = this.getStorageKey();
        StorageService service = this.getStorageService();
        StorageSerializer<Map<String, Consent>> storageSerializer = this.getStorageSerializer();
        assert (consentContext != null && service != null && key != null && storageContext != null && storageSerializer != null);
        try {
            StorageRecord storageRecord = service.read(storageContext, key);
            this.log.debug("{} Read storage record '{}' with context '{}' and key '{}'", new Object[]{this.getLogPrefix(), storageRecord, storageContext, key});
            if (storageRecord == null) {
                this.log.debug("{} No storage record for context '{}' and key '{}'", new Object[]{this.getLogPrefix(), storageContext, key});
                return;
            }
            Map consents = (Map)storageRecord.getValue(storageSerializer, storageContext, key);
            consentContext.getPreviousConsents().putAll(consents);
        }
        catch (IOException e) {
            this.log.error("{} Unable to read consent from storage", (Object)this.getLogPrefix(), (Object)e);
        }
    }
}

