/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.primitive.StringSupport;

public class AttributePredicate
extends AbstractInitializableComponent
implements Predicate<IdPAttribute> {
    @Nonnull
    private Set<String> promptedAttributeIds = CollectionSupport.emptySet();
    @Nonnull
    private Set<String> ignoredAttributeIds = CollectionSupport.emptySet();
    @Nullable
    private Pattern matchExpression;

    public void setPromptedAttributeIds(@Nullable Collection<String> prompted) {
        this.checkSetterPreconditions();
        this.promptedAttributeIds = new HashSet<String>(StringSupport.normalizeStringCollection(prompted));
    }

    public void setIgnoredAttributeIds(@Nullable Collection<String> ignored) {
        this.checkSetterPreconditions();
        this.ignoredAttributeIds = new HashSet<String>(StringSupport.normalizeStringCollection(ignored));
    }

    public void setAttributeIdMatchExpression(@Nullable Pattern expression) {
        this.checkSetterPreconditions();
        this.matchExpression = expression != null && !expression.pattern().isEmpty() ? expression : null;
    }

    @Override
    public boolean test(@Nullable IdPAttribute input) {
        if (input == null) {
            return false;
        }
        if (this.isEmpty(input)) {
            return false;
        }
        String attributeId = input.getId();
        Pattern expression = this.matchExpression;
        if (!this.promptedAttributeIds.isEmpty() && !this.promptedAttributeIds.contains(attributeId)) {
            if (expression == null) {
                return false;
            }
            return expression.matcher(attributeId).matches();
        }
        return !this.ignoredAttributeIds.contains(attributeId) && (expression == null || expression.matcher(attributeId).matches());
    }

    private boolean isEmpty(@Nonnull IdPAttribute input) {
        for (IdPAttributeValue value : input.getValues()) {
            if (value instanceof EmptyAttributeValue) continue;
            return false;
        }
        return true;
    }
}

