/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.relyingparty;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.config.AbstractProfileConfiguration;
import net.shibboleth.idp.profile.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class MockAuthenticationProfileConfiguration
extends AbstractProfileConfiguration
implements AuthenticationProfileConfiguration {
    @Nonnull
    @NonnullElements
    private List<Principal> defaultAuthenticationMethods;
    @Nonnull
    @NonnullElements
    private Set<String> authenticationFlows;
    @Nonnull
    @NonnullElements
    private List<String> nameIDFormatPrecedence;

    public MockAuthenticationProfileConfiguration(@Nonnull @NotEmpty String id, @Nonnull @NonnullElements List<Principal> methods) {
        this(id, methods, Collections.emptySet(), Collections.emptyList());
    }

    public MockAuthenticationProfileConfiguration(@Nonnull @NotEmpty String id, @Nonnull @NonnullElements List<Principal> methods, @Nonnull @NonnullElements Collection<String> flows, @Nonnull @NonnullElements List<String> formats) {
        super(id);
        this.setSecurityConfiguration(new SecurityConfiguration());
        this.setDefaultAuthenticationMethods(methods);
        this.setAuthenticationFlows(flows);
        this.setNameIDFormatPrecedence(formats);
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods() {
        return ImmutableList.copyOf(this.defaultAuthenticationMethods);
    }

    public void setDefaultAuthenticationMethods(@Nonnull @NonnullElements List<Principal> methods) {
        Constraint.isNotNull(methods, (String)"List of methods cannot be null");
        this.defaultAuthenticationMethods = Lists.newArrayList((Iterable)Collections2.filter(methods, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getNameIDFormatPrecedence() {
        return ImmutableList.copyOf(this.nameIDFormatPrecedence);
    }

    public void setNameIDFormatPrecedence(@Nonnull @NonnullElements List<String> formats) {
        Constraint.isNotNull(formats, (String)"List of formats cannot be null");
        this.nameIDFormatPrecedence = Lists.newArrayList((Iterable)Collections2.filter(formats, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows() {
        return this.authenticationFlows;
    }

    public void setAuthenticationFlows(@Nonnull @NonnullElements Collection<String> flows) {
        Constraint.isNotNull(flows, (String)"Collection of flows cannot be null");
        this.authenticationFlows = Sets.newHashSet((Iterable)Collections2.filter(flows, (Predicate)Predicates.notNull()));
    }
}

