/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public abstract class AbstractProfileConfiguration
implements ProfileConfiguration {
    @Nonnull
    @NotEmpty
    private final String profileId;
    @Nullable
    private String inboundFlowId;
    @Nullable
    private String outboundFlowId;
    @Nullable
    private SecurityConfiguration securityConfiguration;

    public AbstractProfileConfiguration(@Nonnull @NotEmpty String id) {
        this.profileId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"Profile identifier cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getId() {
        return this.profileId;
    }

    @Override
    @Nullable
    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(@Nullable SecurityConfiguration configuration) {
        this.securityConfiguration = configuration;
    }

    @Override
    @Nullable
    public String getInboundSubflowId() {
        return this.inboundFlowId;
    }

    public void setInboundSubflowId(@Nullable String id) {
        this.inboundFlowId = StringSupport.trimOrNull((String)id);
    }

    @Override
    @Nullable
    public String getOutboundSubflowId() {
        return this.outboundFlowId;
    }

    public void setOutboundSubflowId(@Nullable String id) {
        this.outboundFlowId = StringSupport.trimOrNull((String)id);
    }

    public int hashCode() {
        return this.profileId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractProfileConfiguration)) {
            return false;
        }
        AbstractProfileConfiguration other = (AbstractProfileConfiguration)obj;
        return Objects.equal((Object)this.profileId, (Object)other.getId());
    }
}

