/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.config;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.RandomIdentifierGenerationStrategy;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.SignatureSigningConfiguration;
import org.opensaml.xmlsec.SignatureValidationConfiguration;

public class SecurityConfiguration {
    @Duration
    @Positive
    private final long clockSkew;
    @Nonnull
    private final IdentifierGenerationStrategy idGenerator;
    @Nullable
    private SignatureValidationConfiguration sigValidateConfig;
    @Nullable
    private SignatureSigningConfiguration sigSigningConfig;
    @Nullable
    private DecryptionConfiguration decryptConfig;
    @Nullable
    private EncryptionConfiguration encryptConfig;

    public SecurityConfiguration() {
        this.clockSkew = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
        this.idGenerator = new RandomIdentifierGenerationStrategy();
    }

    public SecurityConfiguration(@Duration @Positive long skew, @Nonnull IdentifierGenerationStrategy generator) {
        this.clockSkew = (int)Constraint.isGreaterThan((long)0L, (long)skew, (String)"Clock skew must be greater than 0");
        this.idGenerator = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)generator, (String)"Identifier generator cannot be null");
    }

    @Positive
    public long getClockSkew() {
        return this.clockSkew;
    }

    @Nonnull
    public IdentifierGenerationStrategy getIdGenerator() {
        return this.idGenerator;
    }

    @Nullable
    public SignatureValidationConfiguration getSignatureValidationConfiguration() {
        return this.sigValidateConfig;
    }

    public void setSignatureValidationConfiguration(@Nullable SignatureValidationConfiguration config) {
        this.sigValidateConfig = config;
    }

    @Nullable
    public SignatureSigningConfiguration getSignatureSigningConfiguration() {
        return this.sigSigningConfig;
    }

    public void setSignatureSigningConfiguration(@Nullable SignatureSigningConfiguration config) {
        this.sigSigningConfig = config;
    }

    @Nullable
    public DecryptionConfiguration getDecryptionConfiguration() {
        return this.decryptConfig;
    }

    public void setDecryptionConfiguration(@Nullable DecryptionConfiguration config) {
        this.decryptConfig = config;
    }

    @Nullable
    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptConfig;
    }

    public void setEncryptionConfiguration(@Nullable EncryptionConfiguration config) {
        this.encryptConfig = config;
    }
}

