/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.context;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;

public final class MultiRelyingPartyContext
extends BaseContext {
    @Nonnull
    @NonnullElements
    private Map<String, RelyingPartyContext> relyingPartyIdMap = Maps.newHashMap();
    @Nonnull
    @NonnullElements
    private ListMultimap<String, RelyingPartyContext> relyingPartyLabelMap = ArrayListMultimap.create();

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Collection<RelyingPartyContext> getRelyingPartyContexts() {
        return ImmutableList.copyOf(this.relyingPartyIdMap.values());
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Collection<RelyingPartyContext> getRelyingPartyContexts(@Nonnull @NotEmpty String label) {
        return ImmutableList.copyOf((Collection)this.relyingPartyLabelMap.get(Constraint.isNotNull((Object)StringSupport.trimOrNull((String)label), (String)"Label cannot be null or empty")));
    }

    @Nullable
    public RelyingPartyContext getRelyingPartyContextById(@Nonnull @NotEmpty String id) {
        return this.relyingPartyIdMap.get(Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"ID cannot be null or empty"));
    }

    public void addRelyingPartyContext(@Nonnull @NotEmpty String label, @Nonnull RelyingPartyContext context) {
        String trimmed = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)label), (String)"Label cannot be null or empty");
        Constraint.isNotNull((Object)((Object)context), (String)"Context cannot be null");
        Constraint.isNotNull((Object)context.getRelyingPartyId(), (String)"RelyingParty ID cannot be null");
        this.relyingPartyIdMap.put(context.getRelyingPartyId(), context);
        this.relyingPartyLabelMap.put((Object)trimmed, (Object)context);
    }

    public void removeRelyingPartyContext(@Nonnull @NotEmpty String label, @Nonnull RelyingPartyContext context) {
        String trimmed = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)label), (String)"Label cannot be null or empty");
        Constraint.isNotNull((Object)((Object)context), (String)"Context cannot be null");
        Constraint.isNotNull((Object)context.getRelyingPartyId(), (String)"RelyingParty ID cannot be null");
        this.relyingPartyIdMap.remove(context.getRelyingPartyId());
        this.relyingPartyLabelMap.remove((Object)trimmed, (Object)context);
    }
}

