/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.context;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;

public final class RelyingPartyContext
extends BaseContext {
    @Nullable
    private Boolean anonymous;
    @Nullable
    private String relyingPartyId;
    @Nullable
    private BaseContext relyingPartyIdContextTree;
    @Nullable
    private Function<RelyingPartyContext, Boolean> anonymityLookupStrategy;
    @Nullable
    private Function<RelyingPartyContext, String> relyingPartyIdLookupStrategy;
    @Nullable
    private RelyingPartyConfiguration relyingPartyConfiguration;
    @Nullable
    private ProfileConfiguration profileConfiguration;

    public boolean isAnonymous() {
        Boolean flag;
        if (this.anonymous != null) {
            return this.anonymous;
        }
        if (this.anonymityLookupStrategy != null && (flag = (Boolean)this.anonymityLookupStrategy.apply((Object)this)) != null) {
            return flag;
        }
        return true;
    }

    @Nonnull
    public RelyingPartyContext setAnonymous(@Nullable Boolean flag) {
        this.anonymous = flag;
        return this;
    }

    @Nullable
    public String getRelyingPartyId() {
        if (this.relyingPartyId != null) {
            return this.relyingPartyId;
        }
        if (this.relyingPartyIdLookupStrategy != null) {
            return (String)this.relyingPartyIdLookupStrategy.apply((Object)this);
        }
        return null;
    }

    @Nonnull
    public RelyingPartyContext setRelyingPartyId(@Nullable String rpId) {
        this.relyingPartyId = StringSupport.trimOrNull((String)rpId);
        return this;
    }

    @Nullable
    public BaseContext getRelyingPartyIdContextTree() {
        return this.relyingPartyIdContextTree;
    }

    @Nonnull
    public RelyingPartyContext setRelyingPartyIdContextTree(@Nullable BaseContext root) {
        this.relyingPartyIdContextTree = root;
        return this;
    }

    @Nullable
    Function<RelyingPartyContext, Boolean> getAnonymityLookupStrategy() {
        return this.anonymityLookupStrategy;
    }

    @Nonnull
    public RelyingPartyContext setAnonymityLookupStrategy(@Nonnull Function<RelyingPartyContext, Boolean> strategy) {
        this.anonymityLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
        return this;
    }

    @Nullable
    Function<RelyingPartyContext, String> getRelyingPartyIdLookupStrategy() {
        return this.relyingPartyIdLookupStrategy;
    }

    @Nonnull
    public RelyingPartyContext setRelyingPartyIdLookupStrategy(@Nonnull Function<RelyingPartyContext, String> strategy) {
        this.relyingPartyIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
        return this;
    }

    @Nullable
    public RelyingPartyConfiguration getConfiguration() {
        return this.relyingPartyConfiguration;
    }

    @Nonnull
    public RelyingPartyContext setConfiguration(@Nullable RelyingPartyConfiguration config) {
        this.relyingPartyConfiguration = config;
        return this;
    }

    @Nullable
    public ProfileConfiguration getProfileConfig() {
        return this.profileConfiguration;
    }

    @Nonnull
    public RelyingPartyContext setProfileConfig(@Nullable ProfileConfiguration config) {
        this.profileConfiguration = config;
        return this;
    }
}

