/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.context.navigate;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.MultiRelyingPartyContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class RelyingPartyContextLookupById
implements Function<Pair<MultiRelyingPartyContext, String>, RelyingPartyContext> {
    @Nullable
    private final String label;

    public RelyingPartyContextLookupById() {
        this.label = null;
    }

    public RelyingPartyContextLookupById(@Nonnull @NotEmpty String theLabel) {
        this.label = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)theLabel), (String)"Label cannot be null or empty");
    }

    @Nullable
    public RelyingPartyContext apply(@Nullable Pair<MultiRelyingPartyContext, String> input) {
        if (input == null || input.getFirst() == null) {
            return null;
        }
        String id = StringSupport.trimOrNull((String)((String)input.getSecond()));
        if (id == null) {
            return null;
        }
        RelyingPartyContext rpCtx = ((MultiRelyingPartyContext)((Object)input.getFirst())).getRelyingPartyContextById(id);
        if (rpCtx == null && this.label != null) {
            rpCtx = new RelyingPartyContext();
            rpCtx.setRelyingPartyId(id);
            ((MultiRelyingPartyContext)((Object)input.getFirst())).addRelyingPartyContext(this.label, rpCtx);
        }
        return rpCtx;
    }
}

