/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.relyingparty;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.IdentifiedComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class RelyingPartyConfiguration
extends AbstractIdentifiableInitializableComponent
implements IdentifiedComponent,
Predicate<ProfileRequestContext> {
    @NonnullAfterInit
    @NotEmpty
    private String responderId;
    private boolean detailedErrors;
    @Nonnull
    @NonnullElements
    private Map<String, ProfileConfiguration> profileConfigurations;
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = Predicates.alwaysTrue();

    public RelyingPartyConfiguration() {
        this.profileConfigurations = Collections.emptyMap();
    }

    @Nonnull
    @NotEmpty
    public String getResponderId() {
        return this.responderId;
    }

    public void setResponderId(@Nonnull @NotEmpty String responder) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.responderId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)responder), (String)"Responder entity ID cannot be null or empty");
    }

    public boolean isDetailedErrors() {
        return this.detailedErrors;
    }

    public void setDetailedErrors(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.detailedErrors = flag;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Map<String, ProfileConfiguration> getProfileConfigurations() {
        return ImmutableMap.copyOf(this.profileConfigurations);
    }

    @Nullable
    public ProfileConfiguration getProfileConfiguration(@Nullable String profileId) {
        String trimmedId = StringSupport.trimOrNull((String)profileId);
        if (trimmedId == null) {
            return null;
        }
        return this.profileConfigurations.get(trimmedId);
    }

    public void setProfileConfigurations(@Nonnull @NonnullElements Collection<ProfileConfiguration> configs) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(configs, (String)"ProfileConfiguration collection cannot be null");
        this.profileConfigurations = Maps.newHashMap();
        for (ProfileConfiguration config : Collections2.filter(configs, (Predicate)Predicates.notNull())) {
            String trimmedId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)config.getId()), (String)("ID of profile configuration class " + config.getClass().getName() + " cannot be null"));
            this.profileConfigurations.put(trimmedId, config);
        }
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Relying partying configuration activation condition cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.responderId == null) {
            throw new ComponentInitializationException("Responder ID cannot be null or empty");
        }
    }

    public boolean apply(@Nullable ProfileRequestContext input) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return this.activationCondition.apply((Object)input);
    }
}

