/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.context.navigate;

import java.lang.reflect.InvocationTargetException;
import javax.script.ScriptException;
import net.shibboleth.idp.profile.context.navigate.ScriptedContextLookupFunction;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ScriptedFunctionTest {
    static final String STRING_RETURN_7 = "new java.lang.String(\"String\");";
    static final String STRING_RETURN_8 = "JavaString=Java.type(\"java.lang.String\"); new JavaString(\"String\");";
    static final String INTEGER_RETURN_7 = "new java.lang.Integer(37);";
    static final String INTEGER_RETURN_8 = "JavaInteger=Java.type(\"java.lang.Integer\"); new JavaInteger(37);";

    private boolean isV8() {
        String ver = System.getProperty("java.version");
        return ver.startsWith("1.8");
    }

    private String stringReturn() {
        if (this.isV8()) {
            return STRING_RETURN_8;
        }
        return STRING_RETURN_7;
    }

    private String integerReturn() {
        if (this.isV8()) {
            return INTEGER_RETURN_8;
        }
        return INTEGER_RETURN_7;
    }

    @Test
    public void simpleScript() throws ScriptException {
        ProfileRequestContext prc = new ProfileRequestContext();
        Object string = ScriptedContextLookupFunction.inlineScript((String)this.stringReturn()).apply((BaseContext)prc);
        String s = (String)string;
        Assert.assertEquals((String)s, (String)"String");
        Integer integer = (Integer)ScriptedContextLookupFunction.inlineScript((String)this.integerReturn()).apply((BaseContext)prc);
        Assert.assertEquals((int)integer, (int)37);
    }

    @Test
    public void withType() throws ScriptException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ProfileRequestContext prc = new ProfileRequestContext();
        ScriptedContextLookupFunction script1 = ScriptedContextLookupFunction.inlineScript((String)this.stringReturn(), Object.class);
        String string = (String)script1.apply((BaseContext)prc);
        Assert.assertEquals((String)string, (String)"String");
        Assert.assertEquals((Object)ScriptedContextLookupFunction.inlineScript((String)this.stringReturn(), String.class).apply((BaseContext)prc), (Object)"String");
        Assert.assertNull((Object)ScriptedContextLookupFunction.inlineScript((String)this.stringReturn(), Integer.class).apply((BaseContext)prc));
        Integer integer = (Integer)ScriptedContextLookupFunction.inlineScript((String)this.integerReturn()).apply((BaseContext)prc);
        Assert.assertEquals((int)integer, (int)37);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void wrongType() throws ScriptException {
        ScriptedContextLookupFunction script1 = ScriptedContextLookupFunction.inlineScript((String)this.stringReturn(), Object.class);
        script1.apply((BaseContext)new MessageContext());
    }

    @Test
    public void messageContext() throws ScriptException {
        ScriptedContextLookupFunction script1 = ScriptedContextLookupFunction.inlineMessageContextScript((String)this.stringReturn(), Object.class);
        Assert.assertEquals((Object)script1.apply((BaseContext)new MessageContext()), (Object)"String");
        Assert.assertEquals((Object)script1.apply(null), (Object)"String");
    }
}

