/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.logic;

import com.google.common.base.Predicate;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class ScriptedPredicate
implements Predicate<ProfileRequestContext> {
    public static final String DEFAULT_ENGINE = "JavaScript";
    private final Logger log = LoggerFactory.getLogger(ScriptedPredicate.class);
    @Nonnull
    private final EvaluableScript script;
    @Nullable
    private final String logPrefix;

    public ScriptedPredicate(@Nonnull EvaluableScript theScript, @Nullable String extraInfo) {
        this.script = (EvaluableScript)Constraint.isNotNull((Object)theScript, (String)"Supplied script should not be null");
        this.logPrefix = "Scripted Predicate from " + extraInfo + " :";
    }

    public ScriptedPredicate(@Nonnull EvaluableScript theScript) {
        this.script = (EvaluableScript)Constraint.isNotNull((Object)theScript, (String)"Supplied script should not be null");
        this.logPrefix = "Anonymous Scripted Predicate :";
    }

    public boolean apply(@Nullable ProfileRequestContext profileContext) {
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        scriptContext.setAttribute("profileContext", profileContext, 100);
        try {
            Object result = this.script.eval((ScriptContext)scriptContext);
            if (null == result) {
                this.log.error("{} No result returned", (Object)this.logPrefix);
                return false;
            }
            if (result instanceof Boolean) {
                this.log.debug("{} returned {}", (Object)this.logPrefix, result);
                return (Boolean)result;
            }
            this.log.error("{} returned a {}, not a java.lang.Boolean", (Object)this.logPrefix, (Object)result.getClass().toString());
            return false;
        }
        catch (ScriptException e) {
            this.log.error("{} Error while executing Predicate script", (Object)this.logPrefix, (Object)e);
            return false;
        }
    }

    static ScriptedPredicate resourceScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource) throws ScriptException, IOException {
        EvaluableScript script = new EvaluableScript(engineName, resource.getFile());
        return new ScriptedPredicate(script, resource.getDescription());
    }

    static ScriptedPredicate resourceScript(Resource resource) throws ScriptException, IOException {
        return ScriptedPredicate.resourceScript(DEFAULT_ENGINE, resource);
    }

    static ScriptedPredicate inlineScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript(engineName, scriptSource);
        return new ScriptedPredicate(script, "Inline");
    }

    static ScriptedPredicate inlineScript(@Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript(DEFAULT_ENGINE, scriptSource);
        return new ScriptedPredicate(script, "Inline");
    }
}

